/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class FluidHandlerItemCapacity
extends FluidHandlerItemStack
implements IFluidHandlerItemCapacity,
IFluidHandlerMutable,
INBTSerializable {
    private final Fluid fluid;

    public FluidHandlerItemCapacity(ItemStack container, int capacity) {
        this(container, capacity, null);
    }

    public FluidHandlerItemCapacity(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity);
        this.fluid = fluid;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return this.fluid == null || resource == null || this.fluid == resource.getFluid();
    }

    @Override
    public void setCapacity(int capacity) {
        CompoundTag tag = this.getContainer().getOrCreateTag();
        this.capacity = capacity;
        tag.putInt("capacity", capacity);
    }

    @Override
    public int getCapacity() {
        CompoundTag tag = this.getContainer().getOrCreateTag();
        return tag.contains("capacity", 3) ? tag.getInt("capacity") : this.capacity;
    }

    @Nullable
    public FluidStack getFluid() {
        this.capacity = this.getCapacity();
        return super.getFluid();
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }

    public Tag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            fluid.writeToNBT(nbt);
        } else {
            nbt.putString("Empty", "");
        }
        nbt.putInt("capacity", this.getCapacity());
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        CompoundTag tags = (CompoundTag)nbt;
        if (tags.contains("capacity", 3)) {
            this.setCapacity(tags.getInt("capacity"));
        }
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tags);
        this.setFluid(fluid);
    }
}

