/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";

    @SubscribeEvent
    public static void onMainMenuInit(ScreenEvent.Init.Pre event) {
        if (GeneralConfig.devWorldButton && event.getScreen() instanceof TitleScreen) {
            Button buttonBuilt = Button.builder((Component)Component.translatable((String)"general.cyclopscore.dev_world"), button -> {
                String saveName;
                Minecraft mc = Minecraft.getInstance();
                if (!MinecraftHelpers.isShifted()) {
                    LevelSummary devWorldSummary = null;
                    mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    try {
                        List levelList = (List)((CompletableFuture)mc.getLevelSource().loadLevelSummaries(mc.getLevelSource().findLevelCandidates()).exceptionally(p_233202_ -> {
                            mc.delayCrash(CrashReport.forThrowable((Throwable)p_233202_, (String)"Couldn't load level list"));
                            return List.of();
                        })).get(5000L, TimeUnit.MILLISECONDS);
                        for (LevelSummary worldSummary : levelList) {
                            if (!worldSummary.getLevelName().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.getLastPlayed() >= worldSummary.getLastPlayed()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException | LevelStorageException e) {
                        CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.setScreen((Screen)new ErrorScreen((Component)Component.translatable((String)"selectWorld.unable_to_load"), (Component)Component.literal((String)e.getMessage())));
                    }
                    if (devWorldSummary != null && mc.getLevelSource().levelExists(devWorldSummary.getLevelId())) {
                        mc.forceSetScreen((Screen)new GenericDirtMessageScreen((Component)Component.translatable((String)"selectWorld.data_read")));
                        mc.createWorldOpenFlows().checkForBackupAndLoad(devWorldSummary.getLevelId(), () -> event.getScreen().getMinecraft().setScreen(event.getScreen()));
                        return;
                    }
                }
                GameRules gameRules = new GameRules();
                ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DAYLIGHT)).set(false, null);
                ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DO_IMMEDIATE_RESPAWN)).set(true, null);
                ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DO_PATROL_SPAWNING)).set(false, null);
                ((GameRules.BooleanValue)gameRules.getRule(GameRules.RULE_DO_TRADER_SPAWNING)).set(false, null);
                WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(new DataPackConfig(new ArrayList(Minecraft.getInstance().getResourcePackRepository().getAvailableIds()), List.of()), FeatureFlags.REGISTRY.allFlags());
                LevelSettings worldsettings = new LevelSettings(WORLD_NAME_PREFIX, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, gameRules, worlddataconfiguration);
                Function<RegistryAccess, WorldDimensions> generatorSettings = registryAccess -> ((WorldPreset)registryAccess.registryOrThrow(Registries.WORLD_PRESET).getHolderOrThrow(WorldPresets.FLAT).value()).createWorldDimensions();
                long seed = new Random().nextLong();
                WorldOptions worldOptions = new WorldOptions(seed, false, false);
                try {
                    saveName = FileUtil.findAvailableName((Path)mc.getLevelSource().getBaseDir(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.createWorldOpenFlows().createFreshLevel(saveName, worldsettings, worldOptions, generatorSettings, event.getScreen());
            }).pos(event.getScreen().width / 2 + 102, event.getScreen().height / 4 + 48).size(58, 20).build();
            event.addListener((GuiEventListener)buttonBuilt);
        }
    }
}

