/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.ButtonClickPacket;

public abstract class ContainerScreenExtended<T extends ContainerExtended>
extends AbstractContainerScreen<T>
implements IValueNotifiable {
    protected T container;
    protected ResourceLocation texture;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public ContainerScreenExtended(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        ((ContainerExtended)container).setGuiValueListener(this);
        this.container = container;
        this.texture = this.constructGuiTexture();
    }

    protected abstract ResourceLocation constructGuiTexture();

    public ResourceLocation getGuiTexture() {
        return this.texture;
    }

    public void init() {
        this.imageWidth = this.getBaseXSize() + this.offsetX * 2;
        this.imageHeight = this.getBaseYSize() + this.offsetY * 2;
        super.init();
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 166;
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int x, int y) {
        guiGraphics.blit(this.texture, this.leftPos + this.offsetX, this.topPos + this.offsetY, 0, 0, this.imageWidth - 2 * this.offsetX, this.imageHeight - 2 * this.offsetY);
    }

    public boolean isHovering(Slot slotIn, double mouseX, double mouseY) {
        return this.isHovering(slotIn.x - 1, slotIn.y - 1, GuiHelpers.SLOT_SIZE, GuiHelpers.SLOT_SIZE, mouseX, mouseY);
    }

    public boolean isHovering(int left, int top, int right, int bottom, double pointX, double pointY) {
        return RenderHelpers.isPointInRegion(left, top, right, bottom, pointX - (double)this.leftPos, pointY - (double)this.topPos);
    }

    public boolean isPointInRegion(Rectangle region, Point mouse) {
        return this.isHovering(region.x, region.y, region.width, region.height, mouse.x, mouse.y);
    }

    public void drawTooltip(List<Component> lines, PoseStack poseStack, int x, int y) {
        GuiHelpers.drawTooltip(this, poseStack, lines, x, y);
    }

    protected Button.OnPress createServerPressable(String buttonId, @Nullable Button.OnPress clientPressable) {
        return button -> {
            if (clientPressable != null) {
                clientPressable.onPress(button);
            }
            if (((ContainerExtended)this.getMenu()).onButtonClick(buttonId)) {
                CyclopsCore._instance.getPacketHandler().sendToServer(new ButtonClickPacket(buttonId));
            }
        };
    }

    @Override
    public void onUpdate(int valueId, CompoundTag value) {
    }

    protected void refreshValues() {
        for (int id : ((ContainerExtended)this.getMenu()).getValueIds()) {
            this.onUpdate(id, ((ContainerExtended)this.getMenu()).getValue(id));
        }
    }

    public int getGuiLeftTotal() {
        return this.leftPos + this.offsetX;
    }

    public int getGuiTopTotal() {
        return this.topPos + this.offsetY;
    }

    @Override
    public MenuType<?> getValueNotifiableType() {
        return ((ContainerExtended)this.getMenu()).getType();
    }
}

