/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;

public abstract class ContainerScreenScrolling<T extends ScrollingInventoryContainer>
extends ContainerScreenExtended<T> {
    private static final int SEARCH_WIDTH = 89;
    private WidgetTextFieldExtended searchField = null;
    private WidgetScrollBar scrollbar = null;

    public ContainerScreenScrolling(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    @Override
    public void init() {
        super.init();
        if (this.isSearchEnabled()) {
            int searchWidth = this.getSearchWidth();
            int searchX = this.getSearchX();
            int searchY = this.getSearchY();
            if (this.searchField == null) {
                Objects.requireNonNull(this.font);
                this.searchField = new WidgetTextFieldExtended(this.font, this.leftPos + searchX, this.topPos + searchY, searchWidth, 9, (Component)Component.translatable((String)"gui.cyclopscore.search"));
                this.searchField.setMaxLength(64);
                this.searchField.setMaxLength(15);
                this.searchField.setBordered(false);
                this.searchField.setVisible(true);
                this.searchField.setTextColor(0xFFFFFF);
                this.searchField.setCanLoseFocus(true);
                this.searchField.setValue("");
                this.searchField.setWidth(searchWidth);
                this.searchField.setX(this.leftPos + (searchX + searchWidth) - this.searchField.getWidth());
            } else {
                this.searchField.setWidth(searchWidth);
                this.searchField.setX(this.leftPos + (searchX + searchWidth) - this.searchField.getWidth());
                this.searchField.setY(this.topPos + searchY);
            }
            this.addWidget((GuiEventListener)this.searchField);
        }
        if (this.scrollbar == null) {
            ((ScrollingInventoryContainer)this.getMenu()).updateFilter("");
            this.scrollbar = new WidgetScrollBar(this.leftPos + this.getScrollX(), this.topPos + this.getScrollY(), this.getScrollHeight(), (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), (WidgetScrollBar.IScrollCallback)this.getMenu(), ((ScrollingInventoryContainer)this.getMenu()).getPageSize(), this.getScrollRegion());
            this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.getMenu()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.getMenu()).getColumns());
        }
        this.addWidget((GuiEventListener)this.scrollbar);
        this.getScrollbar().scrollTo(this.scrollbar.getCurrentScroll());
    }

    protected Rectangle getScrollRegion() {
        return null;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.isSearchEnabled() && this.searchField.isFocused()) {
            if (this.searchField.charTyped(typedChar, keyCode)) {
                this.updateSearch(this.searchField.getValue());
            }
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.isSearchEnabled() && this.searchField.isFocused() && typedChar != 256) {
            if (this.searchField.keyPressed(typedChar, keyCode, modifiers)) {
                this.updateSearch(this.searchField.getValue());
            }
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isSubsetRenderSlots()) {
            ArrayList oldSlots = Lists.newArrayList((Iterable)((ScrollingInventoryContainer)this.container).slots);
            int startIndex = ((ScrollingInventoryContainer)this.getMenu()).getFirstElement();
            ArrayList newSlots = Lists.newArrayList();
            newSlots.addAll(oldSlots.subList(startIndex, Math.min(oldSlots.size(), startIndex + ((ScrollingInventoryContainer)this.getMenu()).getPageSize() * ((ScrollingInventoryContainer)this.getMenu()).getColumns())));
            newSlots.addAll(oldSlots.subList(((ScrollingInventoryContainer)this.getMenu()).getUnfilteredItemCount(), oldSlots.size()));
            ((ScrollingInventoryContainer)this.container).slots.clear();
            ((ScrollingInventoryContainer)this.container).slots.addAll((Collection)newSlots);
            super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
            ((ScrollingInventoryContainer)this.container).slots.clear();
            ((ScrollingInventoryContainer)this.container).slots.addAll((Collection)oldSlots);
        } else {
            super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected boolean isSubsetRenderSlots() {
        return false;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.isSearchEnabled()) {
            this.searchField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.scrollbar.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.getFocused() != null && this.isDragging() && mouseButton == 0 && this.getFocused().mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    protected void updateSearch(String searchString) {
        ((ScrollingInventoryContainer)this.getMenu()).updateFilter(searchString);
        this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.getMenu()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.getMenu()).getColumns());
        this.scrollbar.scrollTo(0.0f);
    }

    public EditBox getSearchField() {
        return this.searchField;
    }

    public WidgetScrollBar getScrollbar() {
        return this.scrollbar;
    }

    protected int getScrollX() {
        return 175;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 112;
    }

    protected boolean isSearchEnabled() {
        return true;
    }

    protected int getSearchX() {
        return 82;
    }

    protected int getSearchY() {
        return 6;
    }

    protected int getSearchWidth() {
        return 89;
    }
}

