/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.image;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.joml.Matrix4f;

public class Image
implements IImage {
    private final ResourceLocation resourceLocation;
    private final int sheetX;
    private final int sheetY;
    private final int sheetWidth;
    private final int sheetHeight;

    public Image(ResourceLocation resourceLocation, int sheetX, int sheetY, int sheetWidth, int sheetHeight) {
        this.resourceLocation = resourceLocation;
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.sheetWidth = sheetWidth;
        this.sheetHeight = sheetHeight;
    }

    @Override
    public void draw(GuiGraphics gui, int x, int y) {
        gui.blit(this.resourceLocation, x, y, this.sheetX, this.sheetY, this.sheetWidth, this.sheetHeight);
    }

    @Override
    public void drawWithColor(GuiGraphics gui, int x, int y, float r, float g, float b, float a) {
        RenderHelpers.bindTexture(this.resourceLocation);
        RenderHelpers.blitColored(gui, x, y, 0, this.sheetX, this.sheetY, this.sheetWidth, this.sheetHeight, r, g, b, a);
    }

    @Override
    public void drawWorldWithAlpha(TextureManager textureManager, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float alpha) {
        matrixStack.pushPose();
        VertexConsumer vb = renderTypeBuffer.getBuffer(RenderType.text((ResourceLocation)this.getResourceLocation()));
        float u1 = (float)this.getSheetX() / 256.0f;
        float u2 = (float)(this.getSheetX() + this.getSheetWidth()) / 256.0f;
        float v1 = (float)this.getSheetY() / 256.0f;
        float v2 = (float)(this.getSheetY() + this.getSheetHeight()) / 256.0f;
        int a = Math.round(alpha * 255.0f);
        Matrix4f matrix = matrixStack.last().pose();
        vb.vertex(matrix, x2, y2, z).color(255, 255, 255, a).uv(u2, v2).uv2(combinedLight).endVertex();
        vb.vertex(matrix, x2, y1, z).color(255, 255, 255, a).uv(u2, v1).uv2(combinedLight).endVertex();
        vb.vertex(matrix, x1, y1, z).color(255, 255, 255, a).uv(u1, v1).uv2(combinedLight).endVertex();
        vb.vertex(matrix, x1, y2, z).color(255, 255, 255, a).uv(u1, v2).uv2(combinedLight).endVertex();
        matrixStack.popPose();
    }

    @Override
    public int getWidth() {
        return this.sheetWidth;
    }

    @Override
    public int getHeight() {
        return this.sheetHeight;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public int getSheetX() {
        return this.sheetX;
    }

    public int getSheetY() {
        return this.sheetY;
    }

    public int getSheetWidth() {
        return this.sheetWidth;
    }

    public int getSheetHeight() {
        return this.sheetHeight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSheetX() != other.getSheetX()) {
            return false;
        }
        if (this.getSheetY() != other.getSheetY()) {
            return false;
        }
        if (this.getSheetWidth() != other.getSheetWidth()) {
            return false;
        }
        if (this.getSheetHeight() != other.getSheetHeight()) {
            return false;
        }
        ResourceLocation this$resourceLocation = this.getResourceLocation();
        ResourceLocation other$resourceLocation = other.getResourceLocation();
        return !(this$resourceLocation == null ? other$resourceLocation != null : !this$resourceLocation.equals(other$resourceLocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSheetX();
        result = result * 59 + this.getSheetY();
        result = result * 59 + this.getSheetWidth();
        result = result * 59 + this.getSheetHeight();
        ResourceLocation $resourceLocation = this.getResourceLocation();
        result = result * 59 + ($resourceLocation == null ? 43 : $resourceLocation.hashCode());
        return result;
    }

    public String toString() {
        return "Image(resourceLocation=" + this.getResourceLocation() + ", sheetX=" + this.getSheetX() + ", sheetY=" + this.getSheetY() + ", sheetWidth=" + this.getSheetWidth() + ", sheetHeight=" + this.getSheetHeight() + ")";
    }
}

