/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.particle.ParticleDropColoredData;

@OnlyIn(value=Dist.CLIENT)
public class ParticleDropColored
extends TextureSheetParticle {
    private int bobTimer;

    public ParticleDropColored(ParticleDropColoredData data, ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.rCol = data.getRed();
        this.gCol = data.getGreen();
        this.bCol = data.getBlue();
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.bobTimer = 40;
        this.lifetime = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        BlockPos blockPos;
        BlockState blockState;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        if (this.bobTimer-- > 0) {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
        if ((blockState = this.level.getBlockState(blockPos = new BlockPos(Mth.floor((double)this.x), Mth.floor((double)this.y), Mth.floor((double)this.z)))).liquid() || blockState.isSolid()) {
            double d0;
            float h = 1.0f;
            FluidState fluidState = this.level.getFluidState(blockPos);
            if (!fluidState.isEmpty()) {
                h = (float)fluidState.getAmount() / 8.0f;
            }
            if (this.y < (d0 = (double)((float)(Mth.floor((double)this.y) + 1) - h))) {
                this.remove();
            }
        }
    }
}

