/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ListCodecStrict<A>
implements Codec<List<A>> {
    private final Codec<A> elementCodec;

    public ListCodecStrict(Codec<A> elementCodec) {
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<T> encode(List<A> input, DynamicOps<T> ops, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (A a : input) {
            builder.add(this.elementCodec.encodeStart(ops, a));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            ImmutableList.Builder read = ImmutableList.builder();
            Stream.Builder failed = Stream.builder();
            MutableObject result = new MutableObject((Object)DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()));
            ArrayList errorMessages = Lists.newArrayList();
            stream.accept(t -> {
                DataResult element = this.elementCodec.decode(ops, t);
                element.error().ifPresent(e -> {
                    errorMessages.add(e.message());
                    failed.add(t);
                });
                result.setValue((Object)((DataResult)result.getValue()).apply2stable((r, v) -> {
                    read.add(v.getFirst());
                    return r;
                }, element));
            });
            ImmutableList elements = read.build();
            Object errors = ops.createList(failed.build());
            Pair pair = Pair.of((Object)elements, (Object)errors);
            if (!errorMessages.isEmpty()) {
                return DataResult.error(() -> "Errors in list: " + String.join((CharSequence)"; ", errorMessages));
            }
            return ((DataResult)result.getValue()).map(unit -> pair).setPartial((Object)pair);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCodecStrict listCodec = (ListCodecStrict)o;
        return Objects.equals(this.elementCodec, listCodec.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.elementCodec);
    }

    public String toString() {
        return "ListCodecStrict[" + this.elementCodec + "]";
    }
}

