/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.extendedconfig.FluidConfig;

@Mod.EventBusSubscriber(modid="cyclopscore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FluidAction
extends ConfigurableTypeAction<FluidConfig, BaseFlowingFluid.Properties> {
    private final Multimap<String, Pair<FluidConfig, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Pair<FluidConfig, Callable<?>>>>(){

        public List<Pair<FluidConfig, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private boolean registryEventPassed = false;

    @Override
    public void onRegisterForge(FluidConfig config) {
        if (this.registryEventPassed) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolder.put((Object)BuiltInRegistries.FLUID.key().toString(), (Object)Pair.of((Object)config, () -> {
            config.onForgeRegistered();
            return null;
        }));
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegisterEvent event) {
        ((FluidAction)ConfigurableType.FLUID.getConfigurableTypeAction()).onRegistryEventInner(event);
    }

    public void onRegistryEventInner(RegisterEvent event) {
        if (event.getRegistryKey() == BuiltInRegistries.FLUID.key()) {
            this.registryEventPassed = true;
            Registry registry = event.getRegistry();
            this.registryEntriesHolder.get((Object)registry.key().toString()).forEach(pair -> {
                FluidConfig config = (FluidConfig)pair.getLeft();
                BaseFlowingFluid.Properties instance = (BaseFlowingFluid.Properties)config.getInstance();
                java.util.function.Supplier still = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(BaseFlowingFluid.Properties.class, (Object)instance, (String)"still");
                java.util.function.Supplier flowing = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(BaseFlowingFluid.Properties.class, (Object)instance, (String)"flowing");
                this.registerFluid((Registry<Fluid>)registry, event, still, new ResourceLocation(config.getMod().getModId(), config.getNamedId()));
                this.registerFluid((Registry<Fluid>)registry, event, flowing, new ResourceLocation(config.getMod().getModId(), config.getNamedId() + "_flowing"));
                try {
                    if (pair.getRight() != null) {
                        ((Callable)pair.getRight()).call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else if (event.getRegistryKey() == NeoForgeRegistries.FLUID_TYPES.key()) {
            this.registryEntriesHolder.get((Object)BuiltInRegistries.FLUID.key().toString()).forEach(pair -> {
                FluidConfig config = (FluidConfig)pair.getLeft();
                BaseFlowingFluid.Properties instance = (BaseFlowingFluid.Properties)config.getInstance();
                java.util.function.Supplier fluidType = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(BaseFlowingFluid.Properties.class, (Object)instance, (String)"fluidType");
                event.register(event.getRegistry().key(), new ResourceLocation(config.getMod().getModId(), config.getNamedId()), fluidType);
            });
        }
    }

    protected void registerFluid(Registry<Fluid> registry, RegisterEvent event, java.util.function.Supplier<Fluid> fluidSupplier, ResourceLocation name) {
        event.register(registry.key(), name, fluidSupplier);
    }
}

