/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(modid="cyclopscore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemAction
extends ConfigurableTypeActionForge<ItemConfig, Item> {
    private static final List<ItemConfig> MODEL_ENTRIES = Lists.newArrayList();
    private static final List<ItemConfig> COLOR_ENTRIES = Lists.newArrayList();

    @Override
    public void onRegisterForgeFilled(ItemConfig eConfig) {
        ItemAction.register(eConfig, () -> {
            this.polish(eConfig);
            eConfig.onForgeRegistered();
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (ItemConfig config : MODEL_ENTRIES) {
            config.dynamicItemVariantLocation = config.registerDynamicModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (ItemConfig config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            if (config.dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.dynamicItemVariantLocation, dynamicModelElement.createDynamicModel(event));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        for (ItemConfig itemConfig : COLOR_ENTRIES) {
            event.register(itemConfig.getItemColorHandler(), new ItemLike[]{(ItemLike)itemConfig.getInstance()});
        }
    }

    public static void handleItemModel(ItemConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(ItemConfig config) {
        ItemColor itemColorHandler;
        if (MinecraftHelpers.isClientSide() && (itemColorHandler = config.getItemColorHandler()) != null) {
            COLOR_ENTRIES.add(config);
        }
    }
}

