/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.ItemInformationProvider;

public class ItemConfig
extends ExtendedConfigForge<ItemConfig, Item>
implements IModelProviderConfig {
    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation dynamicItemVariantLocation;

    public ItemConfig(ModBase mod, String namedId, Function<ItemConfig, ? extends Item> elementConstructor) {
        super(mod, namedId, elementConstructor);
        if (MinecraftHelpers.isClientSide()) {
            this.dynamicItemVariantLocation = null;
        }
    }

    @Override
    public String getModelName(ItemStack itemStack) {
        return this.getNamedId();
    }

    @Override
    public String getTranslationKey() {
        return "item." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.ITEM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation registerDynamicModel() {
        ResourceLocation itemName = new ResourceLocation(this.getMod().getModId(), this.getNamedId());
        return new ModelResourceLocation(itemName, "inventory");
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        for (ItemStack itemStack : this.getDefaultCreativeTabEntries()) {
            this.getMod().registerDefaultCreativeTabEntry(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    protected Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.singleton(new ItemStack((ItemLike)this.getInstance()));
    }

    @Override
    public void onForgeRegistered() {
        super.onForgeRegistered();
        ItemInformationProvider.registerItem((Item)this.getInstance());
        if (MinecraftHelpers.isClientSide() && this.getInstance() instanceof IDynamicModelElement && ((IDynamicModelElement)this.getInstance()).hasDynamicModel()) {
            ItemAction.handleItemModel(this);
        }
    }

    @Override
    public Registry<? super Item> getRegistry() {
        return BuiltInRegistries.ITEM;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColorHandler() {
        return null;
    }
}

