/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class ParticleConfig<T extends ParticleOptions>
extends ExtendedConfigForge<ParticleConfig<T>, ParticleType<T>> {
    public ParticleConfig(ModBase mod, String namedId, Function<ParticleConfig<T>, ? extends ParticleType<T>> elementConstructor) {
        super(mod, namedId, elementConstructor);
        if (MinecraftHelpers.isClientSide()) {
            mod.getModEventBus().addListener(this::onParticleFactoryRegister);
        }
    }

    @Override
    public String getTranslationKey() {
        return "gui." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.PARTICLE;
    }

    @Override
    public Registry<? super ParticleType<T>> getRegistry() {
        return BuiltInRegistries.PARTICLE_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public abstract ParticleProvider<T> getParticleFactory();

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public abstract ParticleEngine.SpriteParticleRegistration<T> getParticleMetaFactory();

    @OnlyIn(value=Dist.CLIENT)
    public void onParticleFactoryRegister(RegisterParticleProvidersEvent event) {
        ParticleEngine.SpriteParticleRegistration<T> metaFactory;
        ParticleProvider<T> factory = this.getParticleFactory();
        if (factory != null) {
            event.registerSpecial((ParticleType)this.getInstance(), factory);
        }
        if ((metaFactory = this.getParticleMetaFactory()) != null) {
            event.registerSpriteSet((ParticleType)this.getInstance(), metaFactory);
        }
    }
}

