/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class BlockEntityHelpers {
    public static boolean UNSAFE_BLOCK_ENTITY_GETTER = false;

    public static <T> Optional<T> get(DimPos dimPos, Class<T> targetClazz) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return Optional.empty();
        }
        return BlockEntityHelpers.get((BlockGetter)level, dimPos.getBlockPos(), targetClazz);
    }

    public static <T> Optional<T> get(BlockGetter level, BlockPos pos, Class<T> targetClazz) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = UNSAFE_BLOCK_ENTITY_GETTER && level instanceof Level && !((Level)level).isClientSide() && Thread.currentThread() != ((Level)level).getServer().getRunningThread() ? BlockEntityHelpers.getLevelBlockEntityUnchecked((Level)level, pos) : level.getBlockEntity(pos);
        if (blockEntity == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(targetClazz.cast(blockEntity));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Nullable
    static BlockEntity getLevelBlockEntityUnchecked(Level level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return null;
        }
        return level.getChunkAt(pos).getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public static <T, C> Optional<T> getCapability(DimPos dimPos, BlockCapability<T, C> capability) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return Optional.empty();
        }
        return BlockEntityHelpers.getCapability((ILevelExtension)level, dimPos.getBlockPos(), null, capability);
    }

    public static <T, C> Optional<T> getCapability(DimPos dimPos, C context, BlockCapability<T, C> capability) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return Optional.empty();
        }
        return BlockEntityHelpers.getCapability((ILevelExtension)level, dimPos.getBlockPos(), context, capability);
    }

    public static <T, C> Optional<T> getCapability(ILevelExtension level, BlockPos pos, BlockCapability<T, C> capability) {
        return BlockEntityHelpers.getCapability(level, pos, null, capability);
    }

    public static <T, C> Optional<T> getCapability(ILevelExtension level, BlockPos pos, C context, BlockCapability<T, C> capability) {
        Level levelFull = (Level)level;
        BlockState state = levelFull.getBlockState(pos);
        BlockEntity blockEntity = state.hasBlockEntity() ? (BlockEntity)BlockEntityHelpers.get((BlockGetter)levelFull, pos, BlockEntity.class).orElse(null) : null;
        return Optional.ofNullable(level.getCapability(capability, pos, state, blockEntity, context));
    }
}

