/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public final class BlockHelpers {
    public static HolderGetter<Block> HOLDER_GETTER_FORGE = new HolderGetter<Block>(){

        public Optional<Holder.Reference<Block>> get(ResourceKey<Block> key) {
            return BuiltInRegistries.BLOCK.getHolder(key);
        }

        public Optional<HolderSet.Named<Block>> get(TagKey<Block> p_256283_) {
            return Optional.empty();
        }
    };

    public static <T extends Comparable<T>> T getSafeBlockStateProperty(@Nullable BlockState state, Property<T> property, T fallback) {
        Comparable value;
        if (state == null) {
            return fallback;
        }
        try {
            value = state.getValue(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static CompoundTag serializeBlockState(BlockState blockState) {
        return NbtUtils.writeBlockState((BlockState)blockState);
    }

    public static BlockState deserializeBlockState(HolderGetter<Block> holderGetter, CompoundTag serializedBlockState) {
        return NbtUtils.readBlockState(holderGetter, (CompoundTag)serializedBlockState);
    }

    public static BlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = ((BlockItem)itemStack.getItem()).getBlock();
        return block.defaultBlockState();
    }

    public static ItemStack getItemStackFromBlockState(BlockState blockState) {
        return new ItemStack((ItemLike)blockState.getBlock().asItem());
    }

    public static void markForUpdate(Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        world.sendBlockUpdated(pos, blockState, blockState, 3);
    }

    public static void addCollisionBoxToList(BlockPos pos, AABB collidingBox, List<AABB> collisions, AABB addingBox) {
        AABB axisalignedbb;
        if (addingBox != null && collidingBox.intersects(axisalignedbb = addingBox.move(pos))) {
            collisions.add(axisalignedbb);
        }
    }

    public static boolean doesBlockHaveSolidTopSurface(LevelReader world, BlockPos blockPos) {
        return world.getBlockState(blockPos.offset(0, -1, 0)).isSolidRender((BlockGetter)world, blockPos);
    }
}

