/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class CraftingHelpers {
    private static RecipeManager CLIENT_RECIPE_MANAGER;
    private static final LoadingCache<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<RecipeHolder<? extends Recipe>>> CACHE_RECIPES;

    public static void load() {
        if (MinecraftHelpers.isClientSide()) {
            NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, CraftingHelpers::onRecipesLoaded);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRecipesLoaded(RecipesUpdatedEvent event) {
        CLIENT_RECIPE_MANAGER = event.getRecipeManager();
    }

    public static <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> findRecipes(Level world, RecipeType<? extends T> recipeType) {
        return world.isClientSide() ? CraftingHelpers.getClientRecipes(recipeType) : CraftingHelpers.findServerRecipes((ServerLevel)world, recipeType);
    }

    public static RecipeManager getRecipeManager() {
        return MinecraftHelpers.isClientSide() ? (CLIENT_RECIPE_MANAGER != null ? CLIENT_RECIPE_MANAGER : Minecraft.getInstance().getConnection().getRecipeManager()) : Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD), "Server is still loading").getRecipeManager();
    }

    public static <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> getServerRecipe(RecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable((RecipeHolder)CraftingHelpers.getRecipeManager().byType(recipeType).get(recipeName));
    }

    public static <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> findServerRecipe(RecipeType<T> recipeType, C container, Level world) {
        return world.getRecipeManager().getRecipeFor(recipeType, container, world);
    }

    public static <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> findServerRecipes(RecipeType<? extends T> recipeType) {
        return CraftingHelpers.findServerRecipes(Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD)), recipeType);
    }

    public static <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> findServerRecipes(ServerLevel world, RecipeType<? extends T> recipeType) {
        return world.getRecipeManager().getAllRecipesFor(recipeType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> getClientRecipe(RecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable((RecipeHolder)CraftingHelpers.getRecipeManager().byType(recipeType).get(recipeName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getClientRecipes(RecipeType<? extends T> recipeType) {
        return CraftingHelpers.getRecipeManager().getAllRecipesFor(recipeType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends Container, T extends Recipe<C>> RecipeHolder<T> findClientRecipe(RegistryAccess registryAccess, ItemStack itemStack, RecipeType<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (RecipeHolder<T> recipe : CraftingHelpers.getClientRecipes(recipeType)) {
            if (!ItemStack.isSameItemSameTags((ItemStack)recipe.value().getResultItem(registryAccess), (ItemStack)itemStack) || indexAttempt-- != 0) continue;
            return recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + itemStack + "::" + itemStack.getTag() + " with index " + index);
    }

    public static <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> findRecipeCached(RecipeType<T> recipeType, C inventoryCrafting, Level world, boolean uniqueInventory) {
        return (Optional)CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.dimension().location()));
    }

    static {
        CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<RecipeHolder<? extends Recipe>>>(){

            public Optional<RecipeHolder<? extends Recipe>> load(Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation> key) throws Exception {
                ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)key.getRight())));
                return world.getRecipeManager().getRecipeFor((RecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (Level)world);
            }
        });
    }

    public static class CacheableCraftingInventory {
        private final Container inventoryCrafting;

        public CacheableCraftingInventory(Container inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.getContainerSize();
                int height = 1;
                if (inventoryCrafting instanceof CraftingContainer) {
                    width = ((CraftingContainer)inventoryCrafting).getWidth();
                    height = ((CraftingContainer)inventoryCrafting).getHeight();
                }
                this.inventoryCrafting = new TransientCraftingContainer(new AbstractContainerMenu(null, 0){

                    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
                        return ItemStack.EMPTY;
                    }

                    public boolean stillValid(Player playerIn) {
                        return false;
                    }
                }, width, height);
                for (int i = 0; i < inventoryCrafting.getContainerSize(); ++i) {
                    this.inventoryCrafting.setItem(i, inventoryCrafting.getItem(i).copy());
                }
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public Container getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().getContainerSize(); ++i) {
                if (ItemStack.isSameItemSameTags((ItemStack)this.getInventoryCrafting().getItem(i), (ItemStack)((CacheableCraftingInventory)obj).getInventoryCrafting().getItem(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().getContainerSize();
            for (int i = 0; i < this.getInventoryCrafting().getContainerSize(); ++i) {
                hash <<= 1;
                hash |= ItemStackHelpers.getItemStackHashCode(this.getInventoryCrafting().getItem(i));
            }
            return hash;
        }
    }
}

