/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentHelpers {
    public static int doesEnchantApply(ItemStack itemStack, Enchantment enchantment) {
        ListTag enchantmentList = itemStack.getEnchantmentTags();
        for (int i = 0; i < enchantmentList.size(); ++i) {
            if (!BuiltInRegistries.ENCHANTMENT.getKey((Object)enchantment).equals((Object)new ResourceLocation(enchantmentList.getCompound(i).getString("id")))) continue;
            return i;
        }
        return -1;
    }

    public static int getEnchantmentLevel(ItemStack itemStack, int enchantmentListID) {
        ListTag enchlist = itemStack.getEnchantmentTags();
        return enchlist.getCompound(enchantmentListID).getShort("lvl");
    }

    public static Enchantment getEnchantment(ItemStack itemStack, int enchantmentListID) {
        ListTag enchlist = itemStack.getEnchantmentTags();
        return (Enchantment)BuiltInRegistries.ENCHANTMENT.get(new ResourceLocation(enchlist.getCompound(enchantmentListID).getString("id")));
    }

    public static void setEnchantmentLevel(ItemStack itemStack, int enchantmentListID, int level) {
        ListTag enchlist = itemStack.getEnchantmentTags();
        if (level <= 0) {
            enchlist.remove(enchantmentListID);
            if (enchlist.size() == 0) {
                itemStack.getTag().remove("Enchantments");
            }
        } else {
            CompoundTag compound = enchlist.getCompound(enchantmentListID);
            compound.putShort("lvl", (short)level);
        }
        CompoundTag tag = itemStack.getOrCreateTag();
        tag.put("Enchantments", (Tag)enchlist);
    }

    public static void setEnchantmentLevel(ItemStack itemStack, Enchantment enchantment, int level) {
        int existingIndex = EnchantmentHelpers.doesEnchantApply(itemStack, enchantment);
        if (existingIndex >= 0) {
            EnchantmentHelpers.setEnchantmentLevel(itemStack, existingIndex, level);
        } else {
            itemStack.enchant(enchantment, level);
        }
    }
}

