/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.net.URI;
import net.minecraft.Util;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;

public class Helpers {
    public static Object tryParse(String newValue, Object oldValue) {
        Object newValueParsed = null;
        try {
            if (oldValue instanceof Integer) {
                newValueParsed = Integer.parseInt(newValue);
            } else if (oldValue instanceof Boolean) {
                newValueParsed = Boolean.parseBoolean(newValue);
            } else if (oldValue instanceof Double) {
                newValueParsed = Double.parseDouble(newValue);
            } else if (oldValue instanceof String) {
                newValueParsed = newValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newValueParsed;
    }

    public static int RGBToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int RGBAToInt(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int addAlphaToColor(int color, int alpha) {
        return alpha << 24 | color;
    }

    public static int addAlphaToColor(int color, float alpha) {
        return Helpers.addAlphaToColor(color, Math.round(alpha * 255.0f));
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static int rgbToBgra(int color, int alpha) {
        Triple<Float, Float, Float> triple = Helpers.intToRGB(color);
        return Helpers.RGBAToInt((int)(((Float)triple.getRight()).floatValue() * 255.0f), (int)(((Float)triple.getMiddle()).floatValue() * 255.0f), (int)(((Float)triple.getLeft()).floatValue() * 255.0f), alpha);
    }

    public static int rgbToBgr(int color) {
        return Helpers.rgbToBgra(color, 255);
    }

    public static int addSafe(int a, int b) {
        int sum = a + b;
        if (sum < a || sum < b) {
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    public static int multiplySafe(int a, int b) {
        int mul = a * b;
        if (a > 0 && b > 0 && (mul < a || mul < b)) {
            return Integer.MAX_VALUE;
        }
        return mul;
    }

    public static int castSafe(long value) {
        int casted = (int)value;
        if ((long)casted != value) {
            return Integer.MAX_VALUE;
        }
        return casted;
    }

    public static void openUrl(String url) {
        try {
            URI uri = new URI(url);
            Util.getPlatform().openUri(uri);
        }
        catch (Throwable e) {
            e.printStackTrace();
            CyclopsCore.clog(Level.ERROR, e.getMessage());
        }
    }
}

