/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class InventoryHelpers {
    public static void dropItems(Level world, Container inventory, BlockPos blockPos) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            ItemStackHelpers.spawnItemStack(world, blockPos, inventory.getItem(i).copy());
        }
    }

    public static void clearInventory(Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            inventory.setItem(i, ItemStack.EMPTY);
        }
    }

    @Deprecated
    public static void tryReAddToStack(Player player, ItemStack originalStack, ItemStack newStackPart) {
        InventoryHelpers.tryReAddToStack(player, originalStack, newStackPart, InteractionHand.MAIN_HAND);
    }

    public static void tryReAddToStack(Player player, ItemStack originalStack, ItemStack newStackPart, InteractionHand hand) {
        if (!player.isCreative()) {
            if (!originalStack.isEmpty() && originalStack.getCount() == 1) {
                player.getInventory().setItem(hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40, newStackPart);
            } else {
                if (!originalStack.isEmpty()) {
                    originalStack.shrink(1);
                }
                if (!player.getInventory().add(newStackPart)) {
                    player.drop(newStackPart, false);
                }
            }
        }
    }

    public static void validateNBTStorage(Container inventory, ItemStack itemStack, String tagName) {
        CompoundTag tag = itemStack.getOrCreateTag();
        if (!tag.contains(tagName)) {
            tag.put(tagName, (Tag)new ListTag());
        }
        InventoryHelpers.readFromNBT(inventory, tag, tagName);
    }

    public static void readFromNBT(Container inventory, CompoundTag data, String tagName) {
        int j;
        ListTag nbttaglist = data.getList(tagName, 10);
        for (j = 0; j < inventory.getContainerSize(); ++j) {
            inventory.setItem(j, ItemStack.EMPTY);
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.getCompound(j);
            int index = slot.contains("index") ? slot.getInt("index") : (int)slot.getByte("Slot");
            if (index < 0 || index >= inventory.getContainerSize()) continue;
            inventory.setItem(index, ItemStack.of((CompoundTag)slot));
        }
    }

    public static void writeToNBT(Container inventory, CompoundTag data, String tagName) {
        ListTag slots = new ListTag();
        for (int index = 0; index < inventory.getContainerSize(); index = (int)((byte)(index + 1))) {
            ItemStack itemStack = inventory.getItem(index);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slot.putInt("index", index);
            slots.add((Object)slot);
            itemStack.save(slot);
        }
        data.put(tagName, (Tag)slots);
    }

    @Deprecated
    public static ItemStack getItemFromIndex(Player player, int itemIndex) {
        return InventoryHelpers.getItemFromIndex(player, itemIndex, InteractionHand.MAIN_HAND);
    }

    @Deprecated
    public static ItemStack getItemFromIndex(Player player, int itemIndex, InteractionHand hand) {
        return InteractionHand.MAIN_HAND.equals((Object)hand) ? (ItemStack)player.getInventory().items.get(itemIndex) : player.getOffhandItem();
    }

    @Deprecated
    public static void setItemAtIndex(Player player, int itemIndex, InteractionHand hand, ItemStack itemStack) {
        if (InteractionHand.MAIN_HAND.equals((Object)hand)) {
            player.getInventory().setItem(itemIndex, itemStack);
        } else {
            player.setItemInHand(hand, itemStack);
        }
    }

    public static boolean addToSlot(Container inventory, int slot, ItemStack itemStack) {
        return InventoryHelpers.addToSlot(inventory, slot, itemStack, false);
    }

    public static ItemStack addToStack(ItemStack itemStack, ItemStack toAdd) {
        if (ItemStack.isSameItemSameTags((ItemStack)toAdd, (ItemStack)itemStack) && itemStack.getCount() < itemStack.getMaxStackSize()) {
            toAdd = toAdd.copy();
            int toAddCount = Math.min(itemStack.getMaxStackSize() - itemStack.getCount(), toAdd.getCount());
            itemStack.grow(toAddCount);
            toAdd.shrink(toAddCount);
        }
        return toAdd;
    }

    public static ItemStack fillSlot(Container inventory, int slot, ItemStack itemStack, boolean simulate) {
        ItemStack produceStack = inventory.getItem(slot);
        if (produceStack.isEmpty()) {
            if (!simulate) {
                inventory.setItem(slot, itemStack);
            }
            return ItemStack.EMPTY;
        }
        produceStack = produceStack.copy();
        ItemStack remainder = InventoryHelpers.addToStack(produceStack, itemStack);
        if (!simulate && remainder.getCount() != itemStack.getCount()) {
            inventory.setItem(slot, produceStack);
        }
        return remainder;
    }

    public static boolean addToSlot(Container inventory, int slot, ItemStack itemStack, boolean simulate) {
        return InventoryHelpers.fillSlot(inventory, slot, itemStack, simulate).isEmpty();
    }

    public static NonNullList<ItemStack> addToInventory(Container inventory, int[] slots, NonNullList<ItemStack> itemStacks, boolean simulate) {
        NonNullList remaining = NonNullList.create();
        for (ItemStack itemStack : itemStacks) {
            for (int i = 0; i < slots.length; ++i) {
                int slot = slots[i];
                itemStack = InventoryHelpers.fillSlot(inventory, slot, itemStack, simulate);
                if (simulate) {
                    slots = ArrayUtils.remove((int[])slots, (int)i);
                    --i;
                }
                if (itemStack.isEmpty()) break;
            }
            if (itemStack.isEmpty()) continue;
            remaining.add((Object)itemStack);
        }
        return remaining;
    }

    public static void addStackToList(NonNullList<ItemStack> itemStacks, ItemStack itemStack) {
        boolean added = false;
        ItemStack toAdd = itemStack;
        for (ItemStack existingOutputStack : itemStacks) {
            toAdd = InventoryHelpers.addToStack(existingOutputStack, toAdd);
            if (!toAdd.isEmpty()) continue;
            added = true;
            break;
        }
        if (!added) {
            itemStacks.add((Object)toAdd.copy());
        }
    }
}

