/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public final class ItemStackHelpers {
    private static final Random RANDOM = new Random();

    public static void spawnItemStack(Level world, BlockPos pos, ItemStack itemStack) {
        ItemStackHelpers.spawnItemStack(world, pos.getX(), pos.getY(), pos.getZ(), itemStack);
    }

    public static void spawnItemStack(Level world, double x, double y, double z, ItemStack itemStack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (itemStack.getCount() > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > itemStack.getCount()) {
                i = itemStack.getCount();
            }
            ItemStack dropStack = itemStack.copy();
            itemStack.shrink(i);
            dropStack.setCount(i);
            ItemEntity entityitem = new ItemEntity(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, dropStack);
            float motion = 0.05f;
            entityitem.setDeltaMovement(RANDOM.nextGaussian() * (double)motion, RANDOM.nextGaussian() * (double)motion + 0.2, RANDOM.nextGaussian() * (double)motion);
            world.addFreshEntity((Entity)entityitem);
        }
    }

    public static void spawnItemStackToPlayer(Level world, BlockPos pos, ItemStack stack, Player player) {
        if (!world.isClientSide()) {
            float f = 0.5f;
            double xo = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double yo = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double zo = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(world, (double)pos.getX() + xo, (double)pos.getY() + yo, (double)pos.getZ() + zo, stack);
            double d0 = 8.0;
            double d1 = (player.getX() - entityitem.getX()) / d0;
            double d2 = (player.getY() + (double)player.getEyeHeight() - entityitem.getY()) / d0;
            double d3 = (player.getZ() - entityitem.getZ()) / d0;
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().add(d1, d2, d3));
            entityitem.setNoPickUpDelay();
            world.addFreshEntity((Entity)entityitem);
        }
    }

    public static boolean hasPlayerItem(Player player, Item item) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack parseItemStack(String itemStackString) {
        String[] split = itemStackString.split(":");
        String itemName = split[0] + ":" + split[1];
        Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(itemName));
        if (item == null) {
            throw new IllegalArgumentException("Invalid ItemStack item: " + itemName);
        }
        int amount = 1;
        if (split.length > 2) {
            try {
                amount = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid ItemStack amount: " + split[2]);
            }
        }
        return new ItemStack((ItemLike)item, amount);
    }

    public static int getItemStackHashCode(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY.hashCode();
        }
        int result = 1;
        result = 37 * result + stack.getCount();
        result = 37 * result + stack.getItem().hashCode();
        return result;
    }
}

