/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public final class L10NHelpers {
    public static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String key, Object ... params) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return I18n.get((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addStatusInfo(List<Component> infoLines, boolean isEnabled, String statusPrefixKey) {
        MutableComponent autoSupply = Component.translatable((String)KEY_DISABLED);
        if (isEnabled) {
            autoSupply = Component.translatable((String)KEY_ENABLED);
        }
        infoLines.add((Component)Component.translatable((String)statusPrefixKey, (Object[])new Object[]{autoSupply}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addOptionalInfo(List<Component> list, String prefix) {
        String key = prefix + ".info";
        if (I18n.exists((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key, new Object[0]);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX).stream().map(Component::literal).collect(Collectors.toList()));
            } else {
                list.add((Component)Component.translatable((String)"general.cyclopscore.tooltip.info").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true))));
            }
        }
    }
}

