/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.internal.versions.neoform.NeoFormVersion;
import org.cyclops.cyclopscore.CyclopsCore;

public class MinecraftHelpers {
    public static final int MINECRAFT_DAY = 24000;
    public static final int COMPARATOR_MULTIPLIER = 15;
    public static final int SECOND_IN_TICKS = 20;
    public static final int BLOCK_NOTIFY = 1;
    public static final int BLOCK_NOTIFY_CLIENT = 2;
    public static final int BLOCK_NOTIFY_NO_RERENDER = 4;

    public static void setDay(ServerLevel world, boolean toDay) {
        int currentTime = (int)world.getGameTime();
        int newTime = currentTime - currentTime % 12000 + 12000;
        ((ServerLevelData)world.getLevelData()).setGameTime((long)newTime);
    }

    public static boolean isPlayerInventoryFull(Player player) {
        return player.getInventory().getFreeSlot() == -1;
    }

    public static boolean isDevEnvironment() {
        return "mcp".equals(Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.NAMING.get()).orElse("mojang"));
    }

    public static boolean isMinecraftInitialized() {
        return CyclopsCore._instance.isLoaded();
    }

    public static String getMinecraftVersion() {
        return NeoFormVersion.getMCVersion();
    }

    public static String getMinecraftVersionMajorMinor() {
        return String.join((CharSequence)".", Arrays.asList(MinecraftHelpers.getMinecraftVersion().split("\\.")).subList(0, 2));
    }

    public static boolean isModdedEnvironment() {
        return MinecraftHelpers.class.getClassLoader() instanceof TransformingClassLoader;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isShifted() {
        return Screen.hasShiftDown();
    }

    public static int compareBlockPos(BlockPos pos1, BlockPos pos2) {
        int compX = Integer.compare(pos1.getX(), pos2.getX());
        if (compX == 0) {
            int compY = Integer.compare(pos1.getY(), pos2.getY());
            if (compY == 0) {
                return Integer.compare(pos1.getZ(), pos2.getZ());
            }
            return compY;
        }
        return compX;
    }

    public static <T> InteractionResultHolder<T> successAction(T result) {
        return new InteractionResultHolder(InteractionResult.SUCCESS, result);
    }

    public static boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isClientSideThread() {
        return MinecraftHelpers.isClientSide() && Minecraft.getInstance().level != null && Thread.currentThread() == Minecraft.getInstance().level.thread;
    }
}

