/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.item.IngredientPublicConstructor;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;

public class RecipeSerializerHelpers {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static Ingredient getJsonIngredient(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find an ingredient object or string value");
            }
            return Ingredient.EMPTY;
        }
        if (element.isJsonObject()) {
            return Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonObject((JsonObject)json, (String)key), (boolean)required);
        }
        if (element.isJsonArray()) {
            return Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonArray((JsonObject)json, (String)key), (boolean)required);
        }
        String itemName = GsonHelper.getAsString((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(itemName);
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Item: " + itemName + " does not exist")))});
    }

    @Deprecated
    public static Either<ItemStack, ItemStackFromIngredient> getJsonItemStackOrTag(JsonObject json, boolean required) {
        return RecipeSerializerHelpers.getJsonItemStackOrTag(json, required, Collections.emptyList());
    }

    public static Either<ItemStack, ItemStackFromIngredient> getJsonItemStackOrTag(JsonObject json, boolean required, List<String> modPriorities) {
        if (json.has("tag")) {
            return Either.right((Object)RecipeSerializerHelpers.getJsonItemStackFromTag(json, "tag", modPriorities));
        }
        return Either.left((Object)RecipeSerializerHelpers.getJsonItemStack(json, "item", required));
    }

    public static Codec<ItemStackFromIngredient> getCodecItemStackFromIngredient(Supplier<List<String>> modPriorities) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("tag").forGetter(ItemStackFromIngredient::getTag), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"count").forGetter(i -> Optional.of(i.getCount()))).apply((Applicative)builder, (arg_0, arg_1) -> RecipeSerializerHelpers.lambda$getCodecItemStackFromIngredient$2((Supplier)modPriorities, arg_0, arg_1)));
    }

    public static ExtraCodecs.EitherCodec<ItemStack, ItemStackFromIngredient> getCodecItemStackOrTag(Supplier<List<String>> modPriorities) {
        return ExtraCodecs.either((Codec)ItemStack.ITEM_WITH_COUNT_CODEC, RecipeSerializerHelpers.getCodecItemStackFromIngredient(modPriorities));
    }

    public static ExtraCodecs.EitherCodec<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> getCodecItemStackOrTagChance(Supplier<List<String>> modPriorities) {
        return ExtraCodecs.either((Codec)RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("item").forGetter(Pair::getLeft), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Pair::getRight)).apply((Applicative)builder, Pair::of)), (Codec)RecordCodecBuilder.create(builder -> builder.group((App)RecipeSerializerHelpers.getCodecItemStackFromIngredient(modPriorities).fieldOf("tag").forGetter(Pair::getLeft), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Pair::getRight)).apply((Applicative)builder, Pair::of)));
    }

    public static ItemStack getJsonItemStack(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find an item object or string value");
            }
            return ItemStack.EMPTY;
        }
        if (element.isJsonObject()) {
            return RecipeSerializerHelpers.itemStackFromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)key), true, true);
        }
        String itemName = GsonHelper.getAsString((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(itemName);
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Item: " + itemName + " does not exist")));
    }

    public static ItemStack itemStackFromJson(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = GsonHelper.getAsString((JsonObject)json, (String)"item");
        Item item = RecipeSerializerHelpers.getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            CompoundTag nbt = RecipeSerializerHelpers.getNBT(json.get("nbt"));
            CompoundTag tmp = new CompoundTag();
            if (nbt.contains("ForgeCaps")) {
                tmp.put("ForgeCaps", nbt.get("ForgeCaps"));
                nbt.remove("ForgeCaps");
            }
            tmp.put("tag", (Tag)nbt);
            tmp.putString("id", itemName);
            tmp.putInt("Count", GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1));
            return ItemStack.of((CompoundTag)tmp);
        }
        return new ItemStack((ItemLike)item, GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1));
    }

    public static Item getItem(String itemName, boolean disallowsAirInRecipe) {
        ResourceLocation itemKey = new ResourceLocation(itemName);
        if (!BuiltInRegistries.ITEM.containsKey(itemKey)) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(itemKey);
        if (disallowsAirInRecipe && item == Items.AIR) {
            throw new JsonSyntaxException("Invalid item: " + itemName);
        }
        return Objects.requireNonNull(item);
    }

    public static CompoundTag getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return TagParser.parseTag((String)GSON.toJson(element));
            }
            return TagParser.parseTag((String)GsonHelper.convertToString((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e);
        }
    }

    @Deprecated
    public static ItemStackFromIngredient getJsonItemStackFromTag(JsonObject json, String key) {
        return RecipeSerializerHelpers.getJsonItemStackFromTag(json, key, Collections.emptyList());
    }

    public static ItemStackFromIngredient getJsonItemStackFromTag(JsonObject json, String key, List<String> modPriorities) {
        int count = 1;
        if (json.has("count")) {
            count = json.get("count").getAsInt();
        }
        return new ItemStackFromIngredient(modPriorities, key, Ingredient.fromJson((JsonElement)json, (boolean)true), count);
    }

    public static FluidStack deserializeFluidStack(JsonObject json, boolean readNbt) {
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        String fluidName = GsonHelper.getAsString((JsonObject)json, (String)"fluid");
        ResourceLocation resourcelocation = new ResourceLocation(fluidName);
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(resourcelocation);
        if (fluid instanceof EmptyFluid) {
            throw new JsonParseException("Unknown fluid '" + fluidName + "'");
        }
        CompoundTag tag = null;
        if (readNbt && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                tag = element.isJsonObject() ? TagParser.parseTag((String)GSON.toJson(element)) : TagParser.parseTag((String)GsonHelper.convertToString((JsonElement)element, (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        int amount = 1000;
        if (json.has("amount")) {
            amount = GsonHelper.getAsInt((JsonObject)json, (String)"amount");
        }
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack getJsonFluidStack(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find a fluid object or string value");
            }
            return FluidStack.EMPTY;
        }
        if (element.isJsonObject()) {
            return RecipeSerializerHelpers.deserializeFluidStack(GsonHelper.getAsJsonObject((JsonObject)json, (String)key), true);
        }
        String fluidName = GsonHelper.getAsString((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(fluidName);
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(resourcelocation);
        if (fluid instanceof EmptyFluid) {
            throw new JsonParseException("Unknown fluid '" + fluidName + "'");
        }
        return new FluidStack(fluid, 1000);
    }

    public static void writeItemStackOrItemStackIngredient(FriendlyByteBuf buffer, Either<ItemStack, ItemStackFromIngredient> itemStackOrItemStackIngredient) {
        itemStackOrItemStackIngredient.mapBoth(itemStack -> {
            buffer.writeBoolean(true);
            buffer.writeItem(itemStack);
            return null;
        }, ingredient -> {
            buffer.writeBoolean(false);
            ingredient.writeToPacket(buffer);
            return null;
        });
    }

    public static Either<ItemStack, ItemStackFromIngredient> readItemStackOrItemStackIngredient(FriendlyByteBuf buffer) {
        Either outputItem = buffer.readBoolean() ? Either.left((Object)buffer.readItem()) : Either.right((Object)ItemStackFromIngredient.readFromPacket(buffer));
        return outputItem;
    }

    public static void writeItemStackOrItemStackIngredientChance(FriendlyByteBuf buffer, Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> itemStackOrItemStackIngredient) {
        itemStackOrItemStackIngredient.mapBoth(itemStack -> {
            buffer.writeBoolean(true);
            buffer.writeItem((ItemStack)itemStack.getLeft());
            buffer.writeFloat(((Float)itemStack.getRight()).floatValue());
            return null;
        }, ingredient -> {
            buffer.writeBoolean(false);
            ((ItemStackFromIngredient)ingredient.getLeft()).writeToPacket(buffer);
            buffer.writeFloat(((Float)ingredient.getRight()).floatValue());
            return null;
        });
    }

    public static Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> readItemStackOrItemStackIngredientChance(FriendlyByteBuf buffer) {
        Either outputItem = buffer.readBoolean() ? Either.left((Object)Pair.of((Object)buffer.readItem(), (Object)Float.valueOf(buffer.readFloat()))) : Either.right((Object)Pair.of((Object)ItemStackFromIngredient.readFromPacket(buffer), (Object)Float.valueOf(buffer.readFloat())));
        return outputItem;
    }

    public static <T> void writeOptionalToNetwork(FriendlyByteBuf buffer, Optional<T> value, BiConsumer<FriendlyByteBuf, T> writeToBuffer) {
        value.ifPresentOrElse(v -> {
            buffer.writeBoolean(true);
            writeToBuffer.accept(buffer, v);
        }, () -> buffer.writeBoolean(false));
    }

    public static <T> Optional<T> readOptionalFromNetwork(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> readFromBuffer) {
        return buffer.readBoolean() ? Optional.of(readFromBuffer.apply(buffer)) : Optional.empty();
    }

    private static /* synthetic */ ItemStackFromIngredient lambda$getCodecItemStackFromIngredient$2(Supplier modPriorities, String tag, Optional count) {
        return new ItemStackFromIngredient((List)modPriorities.get(), tag, new IngredientPublicConstructor(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(tag))))), count.orElse(1));
    }
}

