/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.init.ModBase;

public class InfoBookRegistry
implements IInfoBookRegistry {
    private final Map<IInfoBook, String> bookPaths = Maps.newIdentityHashMap();
    private final Map<IInfoBook, InfoSection> bookRoots = Maps.newIdentityHashMap();
    private final Queue<SectionInjection> sectionInjections = new LinkedBlockingQueue<SectionInjection>();
    private static volatile boolean infobookStageTagsStatic;
    private static volatile boolean infobookStageRecipesStatic;
    private volatile boolean infobookStageTags = false;
    private volatile boolean infobookStageRecipes = false;

    public InfoBookRegistry() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onClientTagsLoaded);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onClientRecipesLoaded);
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
    }

    @Override
    public void registerInfoBook(IInfoBook infoBook, String path) {
        this.bookPaths.put(infoBook, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSection(ModBase<?> mod, IInfoBook infoBook, String parentSection, String sectionPath) {
        Queue<SectionInjection> queue = this.sectionInjections;
        synchronized (queue) {
            this.sectionInjections.add(new SectionInjection(mod, infoBook, parentSection, sectionPath));
        }
    }

    @Override
    public InfoSection getRoot(IInfoBook infoBook) {
        return this.bookRoots.get(infoBook);
    }

    public static void onClientTagsLoadedStatic(TagsUpdatedEvent event) {
        infobookStageTagsStatic = true;
        if (infobookStageTagsStatic && infobookStageRecipesStatic) {
            infobookStageTagsStatic = false;
            infobookStageRecipesStatic = false;
            AdvancementRewards.reset();
        }
    }

    public static void onClientRecipesLoadedStatic(RecipesUpdatedEvent event) {
        infobookStageRecipesStatic = true;
        if (infobookStageTagsStatic && infobookStageRecipesStatic) {
            infobookStageTagsStatic = false;
            infobookStageRecipesStatic = false;
            AdvancementRewards.reset();
        }
    }

    public static void onServerStartedStatic(ServerStartedEvent event) {
        if (event.getServer().isDedicatedServer()) {
            infobookStageTagsStatic = false;
            infobookStageRecipesStatic = false;
            AdvancementRewards.reset();
        }
    }

    public void onClientTagsLoaded(TagsUpdatedEvent event) {
        this.infobookStageTags = true;
        if (this.infobookStageTags && this.infobookStageRecipes) {
            this.afterRecipesAndTagsLoaded();
        }
    }

    public void onClientRecipesLoaded(RecipesUpdatedEvent event) {
        this.infobookStageRecipes = true;
        if (this.infobookStageTags && this.infobookStageRecipes) {
            this.afterRecipesAndTagsLoaded();
        }
    }

    public void onServerStarted(ServerStartedEvent event) {
        if (event.getServer().isDedicatedServer()) {
            this.afterRecipesAndTagsLoaded();
        }
    }

    public void afterRecipesAndTagsLoaded() {
        this.infobookStageTags = false;
        this.infobookStageRecipes = false;
        for (Map.Entry<IInfoBook, String> entry : this.bookPaths.entrySet()) {
            entry.getKey().getMod().log(Level.INFO, "Loading infobook " + entry.getValue());
            this.bookRoots.put(entry.getKey(), InfoBookParser.initializeInfoBook(entry.getKey().getMod(), entry.getKey(), entry.getValue(), null));
            entry.getKey().setCurrentSection(null);
        }
        for (SectionInjection sectionInjection : this.sectionInjections) {
            InfoSection section = sectionInjection.getInfoBook().getSection(sectionInjection.getParentSection());
            if (section == null) {
                throw new IllegalArgumentException(String.format("Could not find section '%s' in infobook '%s'.", sectionInjection.getParentSection(), sectionInjection.getInfoBook()));
            }
            section.registerSection(InfoBookParser.initializeInfoBook(sectionInjection.getMod(), sectionInjection.getInfoBook(), sectionInjection.getSectionPath(), section));
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, InfoBookRegistry::onClientTagsLoadedStatic);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, InfoBookRegistry::onClientRecipesLoadedStatic);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, InfoBookRegistry::onServerStartedStatic);
        infobookStageTagsStatic = false;
        infobookStageRecipesStatic = false;
    }

    private static final class SectionInjection {
        private final ModBase<?> mod;
        private final IInfoBook infoBook;
        private final String parentSection;
        private final String sectionPath;

        private SectionInjection(ModBase<?> mod, IInfoBook infoBook, String parentSection, String sectionPath) {
            this.mod = mod;
            this.infoBook = Objects.requireNonNull(infoBook);
            this.parentSection = parentSection;
            this.sectionPath = sectionPath;
        }

        public ModBase<?> getMod() {
            return this.mod;
        }

        public IInfoBook getInfoBook() {
            return this.infoBook;
        }

        public String getParentSection() {
            return this.parentSection;
        }

        public String getSectionPath() {
            return this.sectionPath;
        }
    }
}

