/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.HyperLink;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;

public class InfoSection {
    private static final int TITLE_LINES = 4;
    private static final int APPENDIX_OFFSET_LINE = 1;
    private static final int LINK_INDENT = 8;
    private final IInfoBook infoBook;
    @Nullable
    private final ModBase<?> mod;
    private InfoSection parent;
    private int childIndex;
    private String translationKey;
    private List<InfoSection> sections = Lists.newLinkedList();
    private List<List<HyperLink>> links = Lists.newLinkedList();
    private List<SectionAppendix> appendixes;
    protected List<String> paragraphs;
    private ArrayList<String> tagList;
    private int pages;
    private List<List<FormattedCharSequence>> localizedPages;
    private Map<Integer, List<AdvancedButton>> advancedButtons = Maps.newHashMap();

    public InfoSection(IInfoBook infoBook, InfoSection parent, int childIndex, String translationKey, List<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList, ModBase<?> mod) {
        this.infoBook = infoBook;
        this.mod = mod;
        this.parent = parent;
        this.childIndex = childIndex;
        this.translationKey = translationKey;
        this.paragraphs = paragraphs;
        this.appendixes = appendixes;
        this.tagList = tagList;
    }

    @Deprecated
    public InfoSection(IInfoBook infoBook, InfoSection parent, int childIndex, String translationKey, List<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
        this(infoBook, parent, childIndex, translationKey, paragraphs, appendixes, tagList, null);
    }

    public String getRelativeWebPath() {
        if (this.isRoot()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb = sb.append(this.getParent().getRelativeWebPath());
        sb = sb.append(this.getTranslationKey().substring(this.getTranslationKey().lastIndexOf(46) + 1));
        if (this.getMod() != null && this.getParent().getMod() != this.getMod()) {
            sb = sb.append("/" + this.getMod().getModId());
        }
        sb = sb.append(this.getSubSections() > 0 ? "/" : ".html");
        return sb.toString();
    }

    protected void addLinks(int maxLines, int lineHeight, int yOffset, Map<String, Pair<InfoSection, Integer>> softLinks) {
        int linesOnPage = 0;
        if (this.isTitlePage(0)) {
            linesOnPage += 4;
        }
        ArrayList pageLinks = Lists.newArrayListWithCapacity((int)maxLines);
        StringBuilder lines = new StringBuilder();
        for (Map.Entry<String, Pair<InfoSection, Integer>> entry : softLinks.entrySet()) {
            lines.append(" \n");
            if (++linesOnPage >= maxLines) {
                linesOnPage = 0;
                this.links.add(pageLinks);
                pageLinks = Lists.newArrayListWithCapacity((int)maxLines);
            }
            pageLinks.add(new HyperLink((Integer)entry.getValue().getRight(), yOffset + (linesOnPage - 1) * lineHeight, (InfoSection)entry.getValue().getLeft(), entry.getKey()));
        }
        this.paragraphs.add(lines.toString());
        this.links.add(pageLinks);
    }

    protected boolean shouldAddIndex() {
        return true;
    }

    protected static void constructAllLinks(InfoSection root, Map<String, Pair<InfoSection, Integer>> softLinks, int indent, int maxDepth) {
        for (InfoSection section : root.sections) {
            softLinks.put(section.getTranslationKey(), (Pair<InfoSection, Integer>)Pair.of((Object)section, (Object)indent));
            if (maxDepth - 1 <= 0) continue;
            InfoSection.constructAllLinks(section, softLinks, indent + 8, maxDepth - 1);
        }
    }

    public void bakeSection(Font fontRenderer, int width, int maxLines, int lineHeight, int yOffset) {
        if (this.paragraphs.size() == 0 && this.shouldAddIndex()) {
            LinkedHashMap softLinks = Maps.newLinkedHashMap();
            InfoSection.constructAllLinks(this, softLinks, 0, 2);
            this.addLinks(maxLines, lineHeight, yOffset, softLinks);
        }
        Object contents = "";
        Iterator<String> it = this.paragraphs.iterator();
        while (it.hasNext()) {
            String paragraph = it.next();
            contents = (String)contents + InfoSection.formatString(L10NHelpers.localize(paragraph, new Object[0])) + (it.hasNext() ? "\n\n" : "");
        }
        List<FormattedCharSequence> allLines = InfoSection.trimStringToWidth(fontRenderer, FormattedText.of((String)contents), width);
        this.localizedPages = Lists.newLinkedList();
        int linesOnPage = 0;
        ArrayList currentPage = Lists.newArrayList();
        if (this.isTitlePage(0)) {
            for (int i = 1; i < 4; ++i) {
                currentPage.add(FormattedCharSequence.forward((String)"", (Style)Style.EMPTY));
            }
            linesOnPage += 4;
        }
        this.pages = 1;
        for (FormattedCharSequence line : allLines) {
            if (linesOnPage >= maxLines) {
                linesOnPage = 0;
                ++this.pages;
                this.localizedPages.add(currentPage);
                currentPage = Lists.newArrayList();
            }
            ++linesOnPage;
            currentPage.add(line);
        }
        this.localizedPages.add(currentPage);
        HashMap appendixesPerPage = Maps.newHashMap();
        LinkedList appendixCurrentPage = Lists.newLinkedList();
        int appendixPageStart = this.pages - 1;
        int appendixLineStart = ++linesOnPage;
        for (SectionAppendix sectionAppendix : this.appendixes) {
            int lines = InfoSection.getAppendixLineHeight(sectionAppendix, fontRenderer);
            if (linesOnPage + lines > maxLines) {
                appendixesPerPage.put(this.pages - 1, appendixCurrentPage);
                ++this.pages;
                linesOnPage = 0;
                appendixCurrentPage = Lists.newLinkedList();
            }
            appendixCurrentPage.add(sectionAppendix);
            sectionAppendix.setPage(this.pages - 1);
            linesOnPage += lines + 1;
        }
        appendixesPerPage.put(this.pages - 1, appendixCurrentPage);
        for (Map.Entry entry : appendixesPerPage.entrySet()) {
            int freeLines = maxLines;
            int lineStart = 0;
            if ((Integer)entry.getKey() == appendixPageStart) {
                lineStart = appendixLineStart;
                freeLines -= appendixLineStart;
            }
            for (SectionAppendix appendix : (List)entry.getValue()) {
                freeLines -= InfoSection.getAppendixLineHeight(appendix, fontRenderer);
            }
            int linesOffset = freeLines / (((List)entry.getValue()).size() + 1);
            int linesOffsetMod = freeLines % (((List)entry.getValue()).size() + 1);
            lineStart += linesOffset;
            for (SectionAppendix appendix : (List)entry.getValue()) {
                appendix.setLineStart(lineStart);
                lineStart += linesOffset + InfoSection.getAppendixLineHeight(appendix, fontRenderer) + (linesOffsetMod > 0 ? linesOffsetMod-- : 0);
            }
        }
        this.advancedButtons.clear();
        for (SectionAppendix sectionAppendix : this.appendixes) {
            sectionAppendix.preBakeElement(this);
            sectionAppendix.bakeElement(this);
        }
    }

    protected static List<FormattedCharSequence> trimStringToWidth(Font fontRenderer, FormattedText text, int width) {
        List textLines = fontRenderer.getSplitter().splitLines(text, width, Style.EMPTY);
        ArrayList formattedLines = Lists.newArrayList();
        HashMap activeFlags = Maps.newHashMap();
        Character activeColor = null;
        for (FormattedText textLine : textLines) {
            String textLineRaw = textLine.getString();
            Character finalActiveColor = activeColor;
            Optional textLineUnformatted = textLine.visit((style, string) -> {
                if (!activeFlags.isEmpty()) {
                    string = activeFlags.keySet().stream().map(character -> "\u00a7" + character).collect(Collectors.joining()) + (String)string;
                }
                if (finalActiveColor != null) {
                    string = "\u00a7" + finalActiveColor + (String)string;
                }
                return Optional.of(FormattedText.of((String)string, (Style)Style.EMPTY));
            }, Style.EMPTY);
            if (textLineUnformatted.isPresent()) {
                textLine = (FormattedText)textLineUnformatted.get();
            }
            formattedLines.add(Language.getInstance().getVisualOrder(textLine));
            for (int charPos = 0; charPos < textLineRaw.length(); ++charPos) {
                char character;
                if (textLineRaw.charAt(charPos) != '\u00a7') continue;
                if (Character.isDigit(character = textLineRaw.charAt(++charPos)) || character == 'a' || character == 'b' || character == 'c' || character == 'e' || character == 'f') {
                    if (character == '0') {
                        activeColor = null;
                        continue;
                    }
                    activeColor = Character.valueOf(character);
                    continue;
                }
                if (character == 'r') {
                    activeFlags.clear();
                    continue;
                }
                activeFlags.put(Character.valueOf(character), true);
            }
        }
        return formattedLines;
    }

    protected static int getAppendixLineHeight(SectionAppendix appendix, Font fontRenderer) {
        return (int)Math.ceil((double)appendix.getFullHeight() / (double)InfoSection.getFontHeight(fontRenderer));
    }

    public static int getFontHeight(Font fontRenderer) {
        Objects.requireNonNull(fontRenderer);
        return 9;
    }

    public boolean isTitlePage(int page) {
        return this.getTranslationKey() != null && page == 0;
    }

    public void registerSection(InfoSection section) {
        this.sections.add(section);
        section.childIndex = this.sections.size() - 1;
    }

    public int getPages() {
        return this.pages;
    }

    public static String formatString(String string) {
        return (string + "&r").replaceAll("&N", "\n").replaceAll("&", "\u00a7");
    }

    protected List<FormattedCharSequence> getLocalizedPageLines(int page) {
        if (page >= this.localizedPages.size() || page < 0) {
            return null;
        }
        return this.localizedPages.get(page);
    }

    public String getLocalizedTitle() {
        return InfoSection.formatString(L10NHelpers.localize(this.translationKey, new Object[0]));
    }

    public int getSubSections() {
        return this.sections.size();
    }

    public InfoSection getSubSection(int index) {
        return this.sections.get(index);
    }

    public InfoSection getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public List<HyperLink> getLinks(int page) {
        if (this.links.size() <= page || page < 0) {
            return Collections.emptyList();
        }
        return this.links.get(page);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawScreen(ScreenInfoBook gui, GuiGraphics guiGraphics, int mouseX, int mouseY, int yOffset, int width, int height, int page, int mx, int my, int footnoteOffsetX, int footnoteOffsetY) {
        if (page < this.getPages()) {
            Font fontRenderer = gui.getFont();
            List<FormattedCharSequence> lines = this.getLocalizedPageLines(page);
            int l = 0;
            if (lines != null) {
                for (FormattedCharSequence line : lines) {
                    fontRenderer.drawInBatch(line, (float)mouseX, (float)(mouseY + yOffset + l * 9), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    ++l;
                }
            }
            if (this.isTitlePage(page)) {
                gui.drawScaledCenteredString(guiGraphics, this.getLocalizedTitle(), mouseX, mouseY + yOffset + 10, width, 1.5f, width, gui.getTitleColor());
                gui.drawHorizontalRule(guiGraphics, mouseX + width / 2, mouseY + yOffset);
                gui.drawHorizontalRule(guiGraphics, mouseX + width / 2, mouseY + yOffset + 21);
            }
            gui.drawScaledCenteredString(guiGraphics, this.getLocalizedTitle() + " - " + (page + 1) + "/" + this.getPages(), mouseX + (page % 2 == 0 ? 1 : -1) * footnoteOffsetX, mouseY + height + footnoteOffsetY, width, 0.6f, (int)((float)width * 0.75f), Helpers.RGBToInt(190, 190, 190));
            for (SectionAppendix appendix : this.appendixes) {
                if (appendix.getPage() != page) continue;
                appendix.drawScreen(gui, guiGraphics, mouseX, mouseY + yOffset + InfoSection.getAppendixOffsetLine(fontRenderer, appendix), width, height, page, mx, my, true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postDrawScreen(ScreenInfoBook gui, GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height, int page, int mx, int my) {
        if (page < this.getPages()) {
            Font fontRenderer = gui.getFont();
            for (SectionAppendix appendix : this.appendixes) {
                if (appendix.getPage() != page) continue;
                appendix.drawScreen(gui, guiGraphics, mouseX, mouseY + InfoSection.getAppendixOffsetLine(fontRenderer, appendix), width, height, page, mx, my, false);
            }
        }
    }

    public Location getNext(int page, boolean stepSection) {
        if (page < this.getPages() - 1 && !stepSection) {
            return new Location(page + 1, this);
        }
        if (this.getSubSections() > 0) {
            return new Location(0, this.getSubSection(0));
        }
        InfoSection current = this;
        while (!current.isRoot()) {
            if (current.getChildIndex() < current.getParent().getSubSections() - 1) {
                return new Location(0, current.getParent().getSubSection(current.getChildIndex() + 1));
            }
            current = current.getParent();
        }
        return new Location(page, this);
    }

    public Location getPrevious(int page, boolean stepSection) {
        if (page > 0) {
            return new Location(stepSection ? 0 : page - this.getInfoBook().getPagesPerView(), this);
        }
        if (!this.isRoot() && this.getChildIndex() == 0) {
            return new Location(0, this.getParent());
        }
        if (!this.isRoot() && this.getChildIndex() > 0) {
            InfoSection current = this.getParent().getSubSection(this.getChildIndex() - 1);
            while (current.getSubSections() > 0) {
                current = current.getSubSection(current.getSubSections() - 1);
            }
            return new Location(0, current);
        }
        return new Location(page, this);
    }

    protected static int getAppendixOffsetLine(Font fontRenderer, SectionAppendix appendix) {
        return InfoSection.getFontHeight(fontRenderer) * appendix.getLineStart();
    }

    public ArrayList<String> getTags() {
        return this.tagList;
    }

    public List<AdvancedButton> getAdvancedButtons(int page) {
        if (!this.advancedButtons.containsKey(page)) {
            return Collections.emptyList();
        }
        return this.advancedButtons.get(page);
    }

    public void addAdvancedButton(int page, AdvancedButton advancedButton) {
        if (!this.advancedButtons.containsKey(page)) {
            this.advancedButtons.put(page, Lists.newLinkedList());
        }
        this.advancedButtons.get(page).add(advancedButton);
    }

    public <T extends AdvancedButton> void addAdvancedButtons(int page, Collection<T> advancedButtons) {
        for (AdvancedButton advancedButton : advancedButtons) {
            this.addAdvancedButton(page, advancedButton);
        }
    }

    public IInfoBook getInfoBook() {
        return this.infoBook;
    }

    @Nullable
    public ModBase<?> getMod() {
        return this.mod;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public static class Location {
        private int page;
        private InfoSection infoSection;

        public boolean equals(Object o) {
            if (o instanceof Location) {
                return ((Location)o).page == this.page && ((Location)o).infoSection == this.infoSection;
            }
            return false;
        }

        public int hashCode() {
            return this.infoSection.hashCode() >> 4 & this.page;
        }

        public int getPage() {
            return this.page;
        }

        public InfoSection getInfoSection() {
            return this.infoSection;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void setInfoSection(InfoSection infoSection) {
            this.infoSection = infoSection;
        }

        public String toString() {
            return "InfoSection.Location(page=" + this.getPage() + ", infoSection=" + this.getInfoSection() + ")";
        }

        public Location(int page, InfoSection infoSection) {
            this.page = page;
            this.infoSection = infoSection;
        }
    }
}

