/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.network.packet.AdvancementRewardsObtainPacket;

public class AdvancementRewards {
    private static final Map<String, AdvancementRewards> ACHIEVEMENT_REWARDS = Maps.newHashMap();
    public static String NBT_KEY_OBTAINED_PREFIX = "cyclopscore:obtainedAdvancements:";
    private final String id;
    private final List<ResourceLocation> advancements;
    private final List<IReward> rewards;

    public static void reset() {
        ACHIEVEMENT_REWARDS.clear();
    }

    public AdvancementRewards(String id, List<ResourceLocation> advancements, List<IReward> rewards) {
        this.id = id;
        this.advancements = advancements;
        this.rewards = rewards;
        if (ACHIEVEMENT_REWARDS.put(id, this) != null) {
            throw new IllegalArgumentException(String.format("Duplicate advancements rewards id '%s' was found.", id));
        }
    }

    public static AdvancementRewards getAdvancementRewards(String achievementRewardsId) {
        return ACHIEVEMENT_REWARDS.get(achievementRewardsId);
    }

    protected String getNbtTagKey() {
        return NBT_KEY_OBTAINED_PREFIX + this.id;
    }

    public boolean isObtained(Player player) {
        return EntityHelpers.getPersistedPlayerNbt(player).getBoolean(this.getNbtTagKey());
    }

    public void obtain(Player player) {
        if (!this.isObtained(player)) {
            if (player.level().isClientSide()) {
                CyclopsCore._instance.getPacketHandler().sendToServer(new AdvancementRewardsObtainPacket(this.id));
            } else {
                for (IReward reward : this.getRewards()) {
                    reward.obtain(player);
                }
            }
            CompoundTag tag = player.getPersistentData();
            if (!tag.contains("PlayerPersisted")) {
                tag.put("PlayerPersisted", (Tag)new CompoundTag());
            }
            CompoundTag persistedTag = tag.getCompound("PlayerPersisted");
            persistedTag.putBoolean(this.getNbtTagKey(), true);
        }
    }

    public String getId() {
        return this.id;
    }

    public List<ResourceLocation> getAdvancements() {
        return this.advancements;
    }

    public List<IReward> getRewards() {
        return this.rewards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancementRewards)) {
            return false;
        }
        AdvancementRewards other = (AdvancementRewards)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<ResourceLocation> this$advancements = this.getAdvancements();
        List<ResourceLocation> other$advancements = other.getAdvancements();
        if (this$advancements == null ? other$advancements != null : !((Object)this$advancements).equals(other$advancements)) {
            return false;
        }
        List<IReward> this$rewards = this.getRewards();
        List<IReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvancementRewards;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<ResourceLocation> $advancements = this.getAdvancements();
        result = result * 59 + ($advancements == null ? 43 : ((Object)$advancements).hashCode());
        List<IReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        return result;
    }

    public String toString() {
        return "AdvancementRewards(id=" + this.getId() + ", advancements=" + this.getAdvancements() + ", rewards=" + this.getRewards() + ")";
    }
}

