/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.DistExecutor;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.client.key.KeyRegistry;
import org.cyclops.cyclopscore.command.CommandConfig;
import org.cyclops.cyclopscore.command.CommandVersion;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.CreativeModeTabConfig;
import org.cyclops.cyclopscore.helper.LoggerHelper;
import org.cyclops.cyclopscore.init.RegistryManager;
import org.cyclops.cyclopscore.modcompat.IMCHandler;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ModBase<T extends ModBase> {
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_GUI = EnumReferenceKey.create("texture_path_gui", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_MODELS = EnumReferenceKey.create("texture_path_models", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_SKINS = EnumReferenceKey.create("texture_path_skins", String.class);
    public static final EnumReferenceKey<Boolean> REFKEY_RETROGEN = EnumReferenceKey.create("retrogen", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_INVALID_RECIPE = EnumReferenceKey.create("crash_on_invalid_recipe", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_MODCOMPAT_CRASH = EnumReferenceKey.create("crash_on_modcompat_crash", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_INFOBOOK_REWARDS = EnumReferenceKey.create("rewards", Boolean.class);
    private final String modId;
    private final LoggerHelper loggerHelper;
    private final ConfigHandler configHandler;
    private final Map<EnumReferenceKey<?>, Object> genericReference = Maps.newHashMap();
    private final List<WorldStorage> worldStorages = Lists.newLinkedList();
    private final RegistryManager registryManager;
    private final IKeyRegistry keyRegistry;
    private final PacketHandler packetHandler;
    private final ModCompatLoader modCompatLoader;
    private final CapabilityConstructorRegistry capabilityConstructorRegistry;
    private final IMCHandler imcHandler;
    private final IEventBus modEventBus;
    private ICommonProxy proxy;
    private ModContainer container;
    @Nullable
    private CreativeModeTab defaultCreativeTab = null;
    private final List<Pair<ItemStack, CreativeModeTab.TabVisibility>> defaultCreativeTabEntries = Lists.newArrayList();

    public ModBase(String modId, Consumer<T> instanceSetter, IEventBus modEventBus) {
        instanceSetter.accept(this);
        this.modId = modId;
        this.modEventBus = modEventBus;
        this.loggerHelper = this.constructLoggerHelper();
        this.configHandler = this.constructConfigHandler();
        this.registryManager = this.constructRegistryManager();
        this.keyRegistry = new KeyRegistry();
        this.packetHandler = this.constructPacketHandler();
        this.modCompatLoader = this.constructModCompatLoader();
        this.capabilityConstructorRegistry = this.constructCapabilityConstructorRegistry();
        this.imcHandler = this.constructIMCHandler();
        this.getModEventBus().addListener(this::setup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.getModEventBus().addListener(this::setupClient));
        this.getModEventBus().addListener(EventPriority.LOWEST, this::afterRegistriesCreated);
        this.getModEventBus().addListener(EventPriority.HIGHEST, this::beforeRegistriedFilled);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.getModEventBus().addListener(this::onRegisterKeyMappings));
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        DistExecutor.runForDist(() -> () -> {
            this.proxy = this.constructClientProxy();
            return this.proxy;
        }, () -> () -> {
            this.proxy = this.constructCommonProxy();
            return this.proxy;
        });
        this.populateDefaultGenericReferences();
        this.onConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().initialize(Lists.newArrayList());
        this.getConfigHandler().loadModInit();
        if (this.hasDefaultCreativeModeTab()) {
            this.getConfigHandler().addConfigurable(this.constructDefaultCreativeModeTabConfig());
        }
        this.loadModCompats(this.getModCompatLoader());
    }

    public String getModName() {
        return this.getContainer().getModInfo().getDisplayName();
    }

    public IEventBus getModEventBus() {
        return this.modEventBus;
    }

    public ModContainer getContainer() {
        if (this.container == null) {
            this.container = (ModContainer)ModList.get().getModContainerByObject((Object)this).get();
        }
        return this.container;
    }

    protected LoggerHelper constructLoggerHelper() {
        return new LoggerHelper(this.getModId());
    }

    protected ConfigHandler constructConfigHandler() {
        return new ConfigHandler(this);
    }

    protected RegistryManager constructRegistryManager() {
        return new RegistryManager();
    }

    protected PacketHandler constructPacketHandler() {
        return new PacketHandler(this);
    }

    protected ModCompatLoader constructModCompatLoader() {
        return new ModCompatLoader(this);
    }

    protected CapabilityConstructorRegistry constructCapabilityConstructorRegistry() {
        return new CapabilityConstructorRegistry(this);
    }

    protected IMCHandler constructIMCHandler() {
        return new IMCHandler(this);
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand() {
        LiteralArgumentBuilder root = Commands.literal((String)this.getModId());
        root.then(CommandConfig.make(this));
        root.then(CommandVersion.make(this));
        return root;
    }

    public <T> void putGenericReference(EnumReferenceKey<T> key, T value) {
        this.genericReference.put(key, value);
    }

    private void populateDefaultGenericReferences() {
        this.putGenericReference(REFKEY_TEXTURE_PATH_GUI, "textures/gui/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_MODELS, "textures/models/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_SKINS, "textures/skins/");
        this.putGenericReference(REFKEY_RETROGEN, false);
        this.putGenericReference(REFKEY_CRASH_ON_INVALID_RECIPE, false);
        this.putGenericReference(REFKEY_CRASH_ON_MODCOMPAT_CRASH, false);
        this.putGenericReference(REFKEY_INFOBOOK_REWARDS, true);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
    }

    public <T> T getReferenceValue(EnumReferenceKey<T> key) {
        if (!this.genericReference.containsKey(key)) {
            throw new IllegalArgumentException("Could not find " + key + " as generic reference item.");
        }
        return (T)this.genericReference.get(key);
    }

    public void log(String message) {
        this.log(Level.INFO, message);
    }

    public void log(Level level, String message) {
        this.loggerHelper.log(level, message);
    }

    protected void setup(FMLCommonSetupEvent event) {
        this.log(Level.TRACE, "setup()");
        this.getConfigHandler().loadSetup();
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerPacketHandlers(this.getPacketHandler());
            proxy.registerTickHandlers();
        }
    }

    protected void setupClient(FMLClientSetupEvent event) {
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerRenderers();
        }
    }

    protected void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerKeyBindings(this.getKeyRegistry(), event);
        }
    }

    private void afterRegistriesCreated(NewRegistryEvent event) {
        this.getConfigHandler().loadForgeRegistries();
    }

    private void beforeRegistriedFilled(RegisterEvent event) {
        if (event.getRegistryKey().equals(BuiltInRegistries.ATTRIBUTE.key())) {
            this.getConfigHandler().loadForgeRegistriesFilled();
        }
    }

    protected void onServerStarting(ServerStartingEvent event) {
        event.getServer().getCommands().getDispatcher().register(this.constructBaseCommand());
    }

    protected void onServerAboutToStart(ServerAboutToStartEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onAboutToStartEvent(event);
        }
    }

    protected void onServerStarted(ServerStartedEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onStartedEvent(event);
        }
    }

    protected void onServerStopping(ServerStoppingEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onStoppingEvent(event);
        }
    }

    public void registerWorldStorage(WorldStorage worldStorage) {
        this.worldStorages.add(worldStorage);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract IClientProxy constructClientProxy();

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    protected abstract ICommonProxy constructCommonProxy();

    public void registerDefaultCreativeTabEntry(ItemStack itemStack, CreativeModeTab.TabVisibility visibility) {
        if (this.defaultCreativeTabEntries == null) {
            throw new IllegalStateException("Tried to register default tab entries after the CreativeModeTabEvent.BuildContents event");
        }
        if (itemStack.getCount() != 1) {
            throw new IllegalStateException("Tried to register default tab entries with a non-1-count ItemStack");
        }
        this.defaultCreativeTabEntries.add((Pair<ItemStack, CreativeModeTab.TabVisibility>)Pair.of((Object)itemStack, (Object)visibility));
    }

    protected CreativeModeTabConfig constructDefaultCreativeModeTabConfig() {
        return new CreativeModeTabConfig(this, "default", config -> {
            this.defaultCreativeTab = this.constructDefaultCreativeModeTab(CreativeModeTab.builder()).build();
            return this.defaultCreativeTab;
        });
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return builder.title((Component)Component.translatable((String)("itemGroup." + this.getModId()))).icon(() -> new ItemStack((ItemLike)Items.BARRIER)).displayItems((parameters, output) -> {
            for (Pair<ItemStack, CreativeModeTab.TabVisibility> entry : this.defaultCreativeTabEntries) {
                output.accept((ItemStack)entry.getLeft(), (CreativeModeTab.TabVisibility)entry.getRight());
            }
        });
    }

    protected boolean hasDefaultCreativeModeTab() {
        return true;
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
    }

    public ICommonProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.getModId();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public static ModBase get(String modId) {
        ModContainer modContainer = ModList.get().getModContainerById(modId).orElse(null);
        Object mod = modContainer.getMod();
        if (mod instanceof ModBase) {
            return (ModBase)mod;
        }
        return null;
    }

    public String getModId() {
        return this.modId;
    }

    public LoggerHelper getLoggerHelper() {
        return this.loggerHelper;
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public Map<EnumReferenceKey<?>, Object> getGenericReference() {
        return this.genericReference;
    }

    public List<WorldStorage> getWorldStorages() {
        return this.worldStorages;
    }

    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    public IKeyRegistry getKeyRegistry() {
        return this.keyRegistry;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public ModCompatLoader getModCompatLoader() {
        return this.modCompatLoader;
    }

    public CapabilityConstructorRegistry getCapabilityConstructorRegistry() {
        return this.capabilityConstructorRegistry;
    }

    public IMCHandler getImcHandler() {
        return this.imcHandler;
    }

    @Nullable
    public CreativeModeTab getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public List<Pair<ItemStack, CreativeModeTab.TabVisibility>> getDefaultCreativeTabEntries() {
        return this.defaultCreativeTabEntries;
    }

    public void setProxy(ICommonProxy proxy) {
        this.proxy = proxy;
    }

    public void setContainer(ModContainer container) {
        this.container = container;
    }

    public void setDefaultCreativeTab(@Nullable CreativeModeTab defaultCreativeTab) {
        this.defaultCreativeTab = defaultCreativeTab;
    }

    public static class EnumReferenceKey<T> {
        private final String key;
        private final Class<T> type;

        private EnumReferenceKey(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        public static <T> EnumReferenceKey<T> create(String key, Class<T> type) {
            return new EnumReferenceKey<T>(key, type);
        }

        public String getKey() {
            return this.key;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumReferenceKey)) {
                return false;
            }
            EnumReferenceKey other = (EnumReferenceKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumReferenceKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ModBase.EnumReferenceKey(key=" + this.getKey() + ", type=" + this.getType() + ")";
        }
    }
}

