/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import java.util.Iterator;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryIterator
implements Iterator<ItemStack> {
    private final IItemHandlerModifiable inventory;
    private int i;

    public InventoryIterator(IItemHandlerModifiable inventory) {
        this.inventory = inventory;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.inventory.getSlots();
    }

    @Override
    public ItemStack next() {
        return this.inventory.getStackInSlot(this.i++);
    }

    public Pair<Integer, ItemStack> nextIndexed() {
        return Pair.of((Object)this.i, (Object)this.next());
    }

    @Override
    public void remove() {
        if (this.i - 1 >= 0 && this.i - 1 < this.inventory.getSlots()) {
            this.inventory.setStackInSlot(this.i - 1, ItemStack.EMPTY);
        }
    }

    public void replace(ItemStack itemStack) {
        if (this.i - 1 >= 0 && this.i - 1 < this.inventory.getSlots()) {
            this.inventory.setStackInSlot(this.i - 1, itemStack);
        }
    }
}

