/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class LargeInventory
extends SimpleInventory {
    public LargeInventory() {
        this(0, 0);
    }

    public LargeInventory(int size, int stackLimit) {
        super(size, stackLimit);
    }

    @Override
    public void readFromNBT(CompoundTag data, String tag) {
        int j;
        ListTag nbttaglist = data.getList(tag, 10);
        for (j = 0; j < this.getContainerSize(); ++j) {
            this.contents[j] = ItemStack.EMPTY;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.getCompound(j);
            int index = slot.contains("index") ? slot.getInt("index") : slot.getInt("Slot");
            if (index < 0 || index >= this.getContainerSize()) continue;
            this.contents[index] = ItemStack.of((CompoundTag)slot);
        }
    }

    @Override
    public void writeToNBT(CompoundTag data, String tag) {
        ListTag slots = new ListTag();
        for (int index = 0; index < this.getContainerSize(); ++index) {
            ItemStack itemStack = this.getItem(index);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slots.add((Object)slot);
            slot.putInt("Slot", index);
            itemStack.save(slot);
        }
        data.put(tag, (Tag)slots);
    }
}

