/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class NBTSimpleInventoryItemHeld
extends SimpleInventory {
    protected final Player player;
    protected final ItemLocation itemLocation;
    protected final String tagName;

    public NBTSimpleInventoryItemHeld(Player player, ItemLocation itemLocation, int size, int stackLimit, String tagName) {
        super(size, stackLimit);
        this.player = player;
        this.itemLocation = itemLocation;
        this.tagName = tagName;
        InventoryHelpers.validateNBTStorage(this, itemLocation.getItemStack(player), this.tagName);
    }

    @Override
    public void setChanged() {
        ItemStack itemStack = this.itemLocation.getItemStack(this.player);
        CompoundTag tag = itemStack.getOrCreateTag();
        this.writeToNBT(tag, this.tagName);
        itemStack.setTag(tag);
    }

    @Override
    public void readFromNBT(CompoundTag data, String tagName) {
        InventoryHelpers.readFromNBT(this, data, tagName);
    }

    @Override
    public void writeToNBT(CompoundTag data, String tagName) {
        InventoryHelpers.writeToNBT(this, data, tagName);
    }
}

