/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SimpleInventory
implements INBTInventory,
WorldlyContainer {
    protected final ItemStack[] contents;
    private final int stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private int hash;

    public SimpleInventory() {
        this(0, 0);
    }

    public SimpleInventory(int size, int stackLimit) {
        this.contents = new ItemStack[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = ItemStack.EMPTY;
        }
        this.stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int getContainerSize() {
        return this.contents.length;
    }

    public ItemStack getItem(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack removeItem(int slotId, int count) {
        ItemStack stack = this.getItem(slotId);
        if (slotId < this.getContainerSize() && !stack.isEmpty()) {
            if (stack.getCount() > count) {
                ItemStack slotContents = stack.copy();
                ItemStack result = slotContents.split(count);
                this.setItem(slotId, slotContents);
                return result;
            }
            this.setItem(slotId, ItemStack.EMPTY);
            this.onInventoryChanged();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slotId, ItemStack itemstack) {
        if (slotId >= this.getContainerSize()) {
            return;
        }
        this.contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.isEmpty() && itemstack.getCount() > this.getMaxStackSize()) {
            itemstack.setCount(this.getMaxStackSize());
        }
        this.onInventoryChanged();
    }

    public int getMaxStackSize() {
        return this.stackLimit;
    }

    protected void onInventoryChanged() {
        this.setChanged();
    }

    public boolean stillValid(Player entityplayer) {
        return true;
    }

    public void startOpen(Player playerIn) {
    }

    public void stopOpen(Player playerIn) {
    }

    @Override
    public void read(CompoundTag data) {
        this.readFromNBT(data, "items");
    }

    public void readFromNBT(CompoundTag data, String tag) {
        int j;
        ListTag nbttaglist = data.getList(tag, 10);
        for (j = 0; j < this.getContainerSize(); ++j) {
            this.contents[j] = ItemStack.EMPTY;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.getCompound(j);
            int index = slot.contains("index") ? slot.getInt("index") : (int)slot.getByte("Slot");
            if (index < 0 || index >= this.getContainerSize()) continue;
            this.contents[index] = ItemStack.of((CompoundTag)slot);
        }
    }

    @Override
    public void write(CompoundTag data) {
        this.writeToNBT(data, "items");
    }

    public void writeToNBT(CompoundTag data, String tag) {
        ListTag slots = new ListTag();
        for (byte index = 0; index < this.getContainerSize(); index = (byte)((byte)(index + 1))) {
            ItemStack itemStack = this.getItem(index);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slots.add((Object)slot);
            slot.putByte("Slot", index);
            itemStack.save(slot);
        }
        data.put(tag, (Tag)slots);
    }

    public ItemStack removeItemNoUpdate(int slotId) {
        ItemStack stackToTake = this.getItem(slotId);
        if (stackToTake.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setItem(slotId, ItemStack.EMPTY);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return this.contents;
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return i < this.getContainerSize() && i >= 0;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.contents[i] = ItemStack.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChanged() {
        LinkedList dirtyMarkListeners;
        ++this.hash;
        SimpleInventory simpleInventory = this;
        synchronized (simpleInventory) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        this.write(tag);
        return tag;
    }

    @Override
    public void fromNBT(CompoundTag tag) {
        this.read(tag);
    }

    public IItemHandler getItemHandler() {
        return new InvWrapper((Container)this);
    }

    public IItemHandler getItemHandlerSided(Direction side) {
        return new SidedInvWrapper((WorldlyContainer)this, side);
    }

    public int getState() {
        return this.hash;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return true;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

