/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class DamageIndicatedItemComponent {
    public DamageIndicatedItemFluidContainer item;

    public DamageIndicatedItemComponent(DamageIndicatedItemFluidContainer item) {
        this.item = item;
    }

    public void fillDefaultCreativeTabEntries(NonNullList<ItemStack> items, Fluid fluid) {
        ItemStack itemStackFull = new ItemStack((ItemLike)this.item);
        IFluidHandlerItemCapacity fluidHanderFull = FluidHelpers.getFluidHandlerItemCapacity(itemStackFull).orElse(null);
        if (fluidHanderFull != null) {
            fluidHanderFull.fill(new FluidStack(fluid, fluidHanderFull.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
        }
        items.add((Object)itemStackFull);
        ItemStack itemStackEmpty = new ItemStack((ItemLike)this.item);
        items.add((Object)itemStackEmpty);
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        int amount = 0;
        IFluidHandlerItemCapacity fluidHander = FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            amount = fluidStack.getAmount();
        }
        return DamageIndicatedItemComponent.getInfo(fluidStack, amount, fluidHander == null ? 0 : fluidHander.getCapacity());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getInfo(FluidStack fluidStack, int amount, int capacity) {
        MutableComponent prefix = Component.literal((String)"");
        if (!fluidStack.isEmpty()) {
            prefix = Component.translatable((String)fluidStack.getTranslationKey()).append(": ");
        }
        return prefix.append(String.format(Locale.ROOT, "%,d", amount)).append(" / ").append(String.format(Locale.ROOT, "%,d", capacity)).append(" mB");
    }

    public void addInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)((IInformationProvider)itemStack.getItem()).getInfo(itemStack).setStyle(Style.EMPTY.withColor(IInformationProvider.ITEM_PREFIX)));
    }

    public int getDurability(ItemStack itemStack) {
        IFluidHandlerItemCapacity fluidHander = FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        double capacity = fluidHander == null ? 0.0 : (double)fluidHander.getCapacity();
        double amount = FluidHelpers.getAmount(fluidStack);
        return (int)Math.round(amount * 13.0 / capacity);
    }
}

