/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.cyclops.cyclopscore.inventory.InventoryLocationPlayer;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public abstract class ItemGui
extends Item {
    protected ItemGui(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public abstract MenuProvider getContainer(Level var1, Player var2, ItemLocation var3);

    public abstract Class<? extends AbstractContainerMenu> getContainerClass(Level var1, Player var2, ItemStack var3);

    public boolean onDroppedByPlayer(ItemStack itemstack, Player player) {
        if (!itemstack.isEmpty() && player instanceof ServerPlayer && player.containerMenu != null && player.containerMenu.getClass() == this.getContainerClass(player.level(), player, itemstack)) {
            player.closeContainer();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, ItemLocation itemLocation) {
        MenuProvider containerProvider;
        if (!world.isClientSide() && (containerProvider = this.getContainer(world, (Player)player, itemLocation)) != null) {
            player.openMenu(containerProvider, packetBuffer -> this.writeExtraGuiData((FriendlyByteBuf)packetBuffer, world, player, itemLocation));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.awardStat(openStat);
            }
        }
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, ItemLocation itemLocation) {
        ItemLocation.writeToPacketBuffer(packetBuffer, itemLocation);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player instanceof FakePlayer) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            this.openGuiForItemIndex(world, (ServerPlayer)player, InventoryLocationPlayer.getInstance().handToLocation(player, hand, player.getInventory().selected));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }
}

