/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ItemInformationProvider {
    private static final Set<Item> ITEMS_INFO = Sets.newIdentityHashSet();

    public static void registerItem(Item item) {
        ITEMS_INFO.add(item);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (ITEMS_INFO.contains(itemStack.getItem())) {
            L10NHelpers.addOptionalInfo(event.getToolTip(), itemStack.getDescriptionId());
        }
    }

    static {
        if (MinecraftHelpers.isClientSide()) {
            NeoForge.EVENT_BUS.addListener(ItemInformationProvider::onTooltip);
        }
    }
}

