/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public interface IRegistryExportable {
    public JsonObject export();

    public String getName();

    public static JsonObject serializeItemStack(ItemStack itemStack) {
        JsonObject object = new JsonObject();
        object.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
        object.addProperty("count", (Number)itemStack.getCount());
        if (itemStack.hasTag()) {
            object.addProperty("nbt", itemStack.getTag().toString());
        }
        return object;
    }

    public static JsonObject serializeFluidStack(FluidStack fluidStack) {
        JsonObject object = new JsonObject();
        object.addProperty("fluid", BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()).toString());
        object.addProperty("amount", (Number)fluidStack.getAmount());
        if (fluidStack.hasTag()) {
            object.addProperty("nbt", fluidStack.getTag().toString());
        }
        return object;
    }
}

