/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.neoforged.fml.ModList;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.IExternalCompat;
import org.cyclops.cyclopscore.modcompat.IModCompat;

public class ModCompatLoader {
    private static final String CONFIG_CATEGORY = "mod compat";
    protected final ModBase mod;
    protected final List<IExternalCompat> compats = Lists.newLinkedList();
    protected final Set<String> crashedcompats = Sets.newHashSet();

    public ModCompatLoader(ModBase mod) {
        this.mod = mod;
    }

    public void addModCompat(IModCompat modCompat) {
        if (this.shouldLoadExternalCompat(modCompat)) {
            modCompat.createInitializer().initialize();
        }
    }

    protected String getId(IExternalCompat compat) {
        if (compat instanceof IModCompat) {
            return ((IModCompat)compat).getModId();
        }
        return null;
    }

    public boolean shouldLoadExternalCompat(IExternalCompat compat) {
        return compat instanceof IModCompat && this.shouldLoadModCompat((IModCompat)compat);
    }

    public boolean shouldLoadModCompat(IModCompat modCompat) {
        return this.isModLoaded(modCompat) && this.isNotCrashed(modCompat.getModId());
    }

    private boolean isModLoaded(IModCompat modCompat) {
        return "minecraft".equals(modCompat.getModId()) || ModList.get().isLoaded(modCompat.getModId());
    }

    private boolean isNotCrashed(String id) {
        return !this.crashedcompats.contains(id);
    }
}

