/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.jei;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.cyclopscore.helper.CraftingHelpers;

public abstract class RecipeRegistryJeiRecipeWrapper<C extends Container, R extends Recipe<C>, J extends RecipeRegistryJeiRecipeWrapper<C, R, J>> {
    private static final Map<ResourceLocation, RecipeRegistryJeiRecipeWrapper<?, ?, ?>> RECIPE_WRAPPERS = Maps.newHashMap();
    protected final R recipe;

    protected RecipeRegistryJeiRecipeWrapper(RecipeType<R> recipeType, R recipe) {
        this.recipe = recipe;
    }

    public R getRecipe() {
        return this.recipe;
    }

    protected abstract RecipeType<R> getRecipeType();

    protected abstract J newInstance(RecipeHolder<R> var1);

    public static <T extends RecipeType<R>, C extends Container, R extends Recipe<C>, J extends RecipeRegistryJeiRecipeWrapper<C, R, J>> T getJeiRecipeWrapper(R input) {
        return (T)((RecipeType)RECIPE_WRAPPERS.get(input));
    }

    public Collection<J> createAllRecipes() {
        return Collections2.transform(CraftingHelpers.getClientRecipes(this.getRecipeType()), (Function)new Function<RecipeHolder<R>, J>(){

            @Nullable
            public J apply(RecipeHolder<R> input) {
                ResourceLocation id = input.id();
                if (!RECIPE_WRAPPERS.containsKey(id)) {
                    RECIPE_WRAPPERS.put(id, (RecipeRegistryJeiRecipeWrapper<?, ?, ?>)RecipeRegistryJeiRecipeWrapper.this.newInstance(input));
                }
                return RECIPE_WRAPPERS.get(id);
            }
        });
    }
}

