/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.PacketHandler;

public abstract class PacketBase
implements CustomPacketPayload {
    private final ResourceLocation id;

    protected PacketBase(ResourceLocation id) {
        this.id = id;
    }

    public void write(FriendlyByteBuf buf) {
        try {
            this.encode(buf);
        }
        catch (Throwable e) {
            throw new PacketHandler.PacketCodecException("An exception occurred during encoding of packet " + this.toString(), e);
        }
    }

    public ResourceLocation id() {
        return this.id;
    }

    public abstract boolean isAsync();

    public abstract void encode(FriendlyByteBuf var1);

    public abstract void decode(FriendlyByteBuf var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void actionClient(Level var1, Player var2);

    public abstract void actionServer(Level var1, ServerPlayer var2);
}

