/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import io.netty.channel.ChannelHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;

@ChannelHandler.Sharable
public final class PacketHandler {
    private final ModBase mod;
    private final List<Pair<ResourceLocation, Supplier<? extends PacketBase>>> pendingPacketRegistrations;

    public PacketHandler(ModBase mod) {
        this.mod = mod;
        this.pendingPacketRegistrations = Lists.newArrayList();
        mod.getModEventBus().addListener(this::init);
    }

    protected void init(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(this.mod.getModId()).versioned("1.0.0").optional();
        for (Pair<ResourceLocation, Supplier<? extends PacketBase>> pendingPacketRegistration : this.pendingPacketRegistrations) {
            this.registerActual(registrar, (ResourceLocation)pendingPacketRegistration.getLeft(), (Supplier)pendingPacketRegistration.getRight());
        }
    }

    public <P extends PacketBase> void register(ResourceLocation id, Supplier<P> packetSupplier) {
        this.pendingPacketRegistrations.add((Pair<ResourceLocation, Supplier<? extends PacketBase>>)Pair.of((Object)id, packetSupplier));
    }

    protected <P extends PacketBase> void registerActual(IPayloadRegistrar registrar, ResourceLocation id, Supplier<P> packetSupplier) {
        registrar.play(id, buffer -> {
            PacketBase packet = (PacketBase)packetSupplier.get();
            try {
                packet.decode((FriendlyByteBuf)buffer);
            }
            catch (Throwable e) {
                throw new PacketCodecException("An exception occurred during decoding of packet " + packet.toString(), e);
            }
            return packet;
        }, handler -> {
            handler.client((packet, ctx) -> {
                if (packet.isAsync()) {
                    this.handlePacketClient(ctx, (PacketBase)packet);
                } else {
                    ctx.workHandler().submitAsync(() -> this.handlePacketClient(ctx, (PacketBase)packet));
                }
            });
            handler.server((packet, ctx) -> {
                if (packet.isAsync()) {
                    this.handlePacketServer(ctx, (PacketBase)packet);
                } else {
                    ctx.workHandler().submitAsync(() -> this.handlePacketServer(ctx, (PacketBase)packet));
                }
            });
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketClient(PlayPayloadContext context, PacketBase packet) {
        packet.actionClient(context.level().orElse(Minecraft.getInstance().player != null ? Minecraft.getInstance().player.level() : null), (Player)Minecraft.getInstance().player);
    }

    public void handlePacketServer(PlayPayloadContext context, PacketBase packet) {
        packet.actionServer(context.level().orElse(context.player().isPresent() ? ((Player)context.player().get()).level() : null), (ServerPlayer)context.player().get());
    }

    public void sendToServer(PacketBase packet) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{packet});
    }

    public void sendToPlayer(PacketBase packet, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{packet});
    }

    public void sendToAllAround(PacketBase packet, PacketDistributor.TargetPoint point) {
        PacketDistributor.NEAR.with((Object)point).send(new CustomPacketPayload[]{packet});
    }

    public void sendToDimension(PacketBase packet, ResourceKey<Level> dimension) {
        PacketDistributor.DIMENSION.with(dimension).send(new CustomPacketPayload[]{packet});
    }

    public void sendToAll(PacketBase packet) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{packet});
    }

    public static class PacketCodecException
    extends RuntimeException {
        public PacketCodecException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

