/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public abstract class PlayerPositionPacket
extends PacketCodec {
    private static final int DEFAULT_RANGE = 3000;
    @CodecField
    protected String uuid;
    @CodecField
    protected Vec3 position = new Vec3(0.0, 0.0, 0.0);
    @CodecField
    private int range = 3000;

    public PlayerPositionPacket(ResourceLocation id) {
        super(id);
    }

    public PlayerPositionPacket(ResourceLocation id, Player player) {
        this(id, player, 3000);
    }

    public PlayerPositionPacket(ResourceLocation id, Player player, int range) {
        super(id);
        this.uuid = player.getUUID().toString();
        this.position = player.position();
        this.range = range;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level level, Player player) {
        if (this.uuid == null) {
            this.getModInstance().log(Level.WARN, "Got PlayerPositionPacket with empty uuid");
            return;
        }
        try {
            UUID uuid = UUID.fromString(this.uuid);
            if (player != null && !player.getUUID().equals(uuid)) {
                player = level.getPlayerByUUID(uuid);
            }
            if (player == null) {
                this.getModInstance().log(Level.WARN, "Received PlayerPositionPacket for player with uuid '" + uuid + "', but player doesn't exist");
            } else {
                this.performClientAction(level, player);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void actionServer(net.minecraft.world.level.Level level, ServerPlayer player) {
        this.getModInstance().getPacketHandler().sendToAllAround(this.create((Player)player, this.range), LocationHelpers.createTargetPointFromEntity((Entity)player, this.range));
    }

    protected abstract PlayerPositionPacket create(Player var1, int var2);

    protected abstract ModBase getModInstance();

    protected abstract void performClientAction(net.minecraft.world.level.Level var1, Player var2);
}

