/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;

public class RingOfFirePacket
extends PlayerPositionPacket {
    public static final ResourceLocation ID = new ResourceLocation("cyclopscore", "ring_of_fire");
    private static final double RING_AREA = (double)0.9f;

    public RingOfFirePacket() {
        super(ID);
    }

    public RingOfFirePacket(Player player) {
        super(ID, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void showFireRing(Level world, Vec3 pos) {
        double area = 0.9f;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double x = pos.x;
            double y = pos.y;
            double z = pos.z;
            double particleX = x + xOffset + (double)(world.random.nextFloat() / 5.0f);
            double particleY = y + yOffset + (double)(world.random.nextFloat() / 5.0f);
            double particleZ = z + zOffset + (double)(world.random.nextFloat() / 5.0f);
            float particleMotionX = (float)xOffset / 50.0f;
            float particleMotionY = 0.01f;
            float particleMotionZ = (float)zOffset / 50.0f;
            if (world.random.nextInt(20) == 0) {
                world.addParticle((ParticleOptions)ParticleTypes.LAVA, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                continue;
            }
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @Override
    protected PlayerPositionPacket create(Player player, int range) {
        return new RingOfFirePacket(player);
    }

    @Override
    protected ModBase getModInstance() {
        return CyclopsCore._instance;
    }

    @Override
    protected void performClientAction(Level level, Player player) {
        RingOfFirePacket.showFireRing(level, this.position);
    }
}

