/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class SendPlayerNbtPacket
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("cyclopscore", "send_player_nbt");
    @CodecField
    private CompoundTag nbtData;

    public SendPlayerNbtPacket() {
        super(ID);
    }

    public SendPlayerNbtPacket(Player player) {
        this();
        this.nbtData = EntityHelpers.getPersistedPlayerNbt(player);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level level, Player player) {
        player.getPersistentData().put("PlayerPersisted", (Tag)this.nbtData);
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
    }
}

