/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet.debug;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketSync;

public class PingPongPacketAsync
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("cyclopscore", "ping_pong_async");
    @CodecField
    protected int remaining;

    public PingPongPacketAsync() {
        super(ID);
    }

    public PingPongPacketAsync(int remaining) {
        this();
        this.remaining = remaining;
    }

    public PingPongPacketAsync(ResourceLocation id) {
        super(id);
    }

    public PingPongPacketAsync(ResourceLocation id, int remaining) {
        super(id);
        this.remaining = remaining;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    protected void log(Player player, String message) {
        player.sendSystemMessage((Component)Component.literal((String)message));
    }

    protected PingPongPacketAsync newPacket() {
        return new PingPongPacketSync(this.remaining - 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level level, Player player) {
        if (this.remaining > 0) {
            CyclopsCore._instance.getPacketHandler().sendToServer(this.newPacket());
        }
        this.log(player, String.format("[PING %s] Fields: %s", this.remaining, this.toString()));
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
        if (this.remaining > 0) {
            CyclopsCore._instance.getPacketHandler().sendToPlayer(this.newPacket(), player);
        }
        this.log((Player)player, String.format("[PONG %s] Fields: %s", this.remaining, this.toString()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List fields = (List)this.fieldCache.get(null);
        for (Field field : fields) {
            sb.append(" ");
            sb.append(field);
            sb.append("=");
            try {
                sb.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                sb.append("ERROR(" + e.getMessage() + ")");
            }
        }
        return sb.toString();
    }
}

