/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;

public interface INBTSerializable {
    public CompoundTag toNBT();

    public void fromNBT(CompoundTag var1);

    public static class SelfNBTClassType
    extends NBTClassType<INBTSerializable> {
        private final Class<?> fieldType;

        @Override
        public void writePersistedField(String name, INBTSerializable object, CompoundTag tag) {
            try {
                Method method = this.fieldType.getMethod("toNBT", new Class[0]);
                tag.put(name, (Tag)method.invoke((Object)object, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method toNBT for field " + name + " of class " + this.fieldType + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in toNBT for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke toNBT for " + name + ".");
            }
        }

        @Override
        public INBTSerializable readPersistedField(String name, CompoundTag tag) {
            try {
                Constructor<?> constructor = this.fieldType.getConstructor(new Class[0]);
                if (constructor == null) {
                    throw new RuntimeException("The NBT serializable " + name + " of class " + this.fieldType + " must have a constructor without parameters.");
                }
                Method method = this.fieldType.getMethod("fromNBT", CompoundTag.class);
                INBTSerializable obj = (INBTSerializable)constructor.newInstance(new Object[0]);
                if (tag.contains(name)) {
                    method.invoke((Object)obj, tag.get(name));
                } else {
                    CyclopsCore.clog(Level.WARN, String.format("The tag %s did not contain the key %s, skipping reading.", tag, name));
                }
                return obj;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method fromNBT for field " + name + " of class " + this.fieldType + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in fromNBT for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke fromNBT for " + name + ".");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException("Something went wrong while calling the empty constructor for " + name + "of class " + this.fieldType + ".");
            }
        }

        @Override
        public INBTSerializable getDefaultValue() {
            return null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelfNBTClassType)) {
                return false;
            }
            SelfNBTClassType other = (SelfNBTClassType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$fieldType = this.getFieldType();
            Class<?> other$fieldType = other.getFieldType();
            return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelfNBTClassType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $fieldType = this.getFieldType();
            result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
            return result;
        }

        public SelfNBTClassType(Class<?> fieldType) {
            this.fieldType = fieldType;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public String toString() {
            return "INBTSerializable.SelfNBTClassType(fieldType=" + this.getFieldType() + ")";
        }
    }
}

