/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.cyclops.cyclopscore.recipe.type.RecipeCraftingShapelessCustomOutput;

public class RecipeCraftingShapedCustomOutput
extends ShapedRecipe {
    private final Serializer serializer;
    private final ItemStack recipeOutput;
    private final ShapedRecipePattern shapedRecipePattern;

    public RecipeCraftingShapedCustomOutput(Serializer serializer, String groupIn, CraftingBookCategory category, ShapedRecipePattern shapedRecipePattern, ItemStack recipeOutputIn, boolean showNotification) {
        super(groupIn, category, shapedRecipePattern, recipeOutputIn, showNotification);
        this.serializer = serializer;
        this.recipeOutput = recipeOutputIn;
        this.shapedRecipePattern = shapedRecipePattern;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer outputTransformer = this.serializer.getOutputTransformer();
        if (outputTransformer != null) {
            return outputTransformer.transform(inv, this.getResultItem());
        }
        return this.getResultItem().copy();
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCraftingShapedCustomOutput> {
        private final Supplier<ItemStack> outputProvider;
        @Nullable
        private final RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer outputTransformer;
        public final Codec<RecipeCraftingShapedCustomOutput> codec;

        public Serializer(Supplier<ItemStack> outputProvider, @Nullable RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer outputTransformer) {
            this.outputProvider = outputProvider;
            this.outputTransformer = outputTransformer;
            this.codec = RecordCodecBuilder.create(p_311728_ -> p_311728_.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_311729_ -> p_311729_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category()), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.shapedRecipePattern), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(p_311731_ -> p_311731_.showNotification())).apply((Applicative)p_311728_, (group, category, shapedRecipePattern, showNotification) -> new RecipeCraftingShapedCustomOutput(this, (String)group, (CraftingBookCategory)category, (ShapedRecipePattern)shapedRecipePattern, this.outputProvider.get(), (boolean)showNotification)));
        }

        public Serializer(Supplier<ItemStack> outputProvider) {
            this(outputProvider, null);
        }

        @Nullable
        public RecipeCraftingShapelessCustomOutput.Serializer.IOutputTransformer getOutputTransformer() {
            return this.outputTransformer;
        }

        public Codec<RecipeCraftingShapedCustomOutput> codec() {
            return this.codec;
        }

        public RecipeCraftingShapedCustomOutput fromNetwork(FriendlyByteBuf p_44240_) {
            String s = p_44240_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_44240_.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.fromNetwork((FriendlyByteBuf)p_44240_);
            ItemStack itemstack = p_44240_.readItem();
            boolean flag = p_44240_.readBoolean();
            return new RecipeCraftingShapedCustomOutput(this, s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        public void toNetwork(FriendlyByteBuf p_44227_, RecipeCraftingShapedCustomOutput p_44228_) {
            p_44227_.writeUtf(p_44228_.getGroup());
            p_44227_.writeEnum((Enum)p_44228_.category());
            p_44228_.shapedRecipePattern.toNetwork(p_44227_);
            p_44227_.writeItem(p_44228_.getResultItem());
            p_44227_.writeBoolean(p_44228_.showNotification());
        }
    }
}

