/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class RecipeCraftingShapelessCustomOutput
extends ShapelessRecipe {
    private final Serializer serializer;
    private final ItemStack recipeOutput;

    public RecipeCraftingShapelessCustomOutput(Serializer serializer, String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(groupIn, category, recipeOutputIn, recipeItemsIn);
        this.serializer = serializer;
        this.recipeOutput = recipeOutputIn;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        Serializer.IOutputTransformer outputTransformer = this.serializer.getOutputTransformer();
        if (outputTransformer != null) {
            return outputTransformer.transform(inv, this.getResultItem());
        }
        return this.getResultItem().copy();
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCraftingShapelessCustomOutput> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shapeless");
        private final Supplier<ItemStack> outputProvider;
        @Nullable
        private final IOutputTransformer outputTransformer;
        private final Codec<RecipeCraftingShapelessCustomOutput> codec;

        public Serializer(Supplier<ItemStack> outputProvider, @Nullable IOutputTransformer outputTransformer) {
            this.outputProvider = outputProvider;
            this.outputTransformer = outputTransformer;
            this.codec = RecordCodecBuilder.create(p_311734_ -> p_311734_.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_301127_ -> p_301127_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category()), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
                Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
                if (aingredient.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
            }, DataResult::success).forGetter(p_300975_ -> p_300975_.getIngredients())).apply((Applicative)p_311734_, (group, category, ingredients) -> new RecipeCraftingShapelessCustomOutput(this, (String)group, (CraftingBookCategory)category, this.outputProvider.get(), (NonNullList<Ingredient>)ingredients)));
        }

        public Serializer(Supplier<ItemStack> outputProvider) {
            this(outputProvider, null);
        }

        @Nullable
        public IOutputTransformer getOutputTransformer() {
            return this.outputTransformer;
        }

        public Codec<RecipeCraftingShapelessCustomOutput> codec() {
            return this.codec;
        }

        public RecipeCraftingShapelessCustomOutput fromNetwork(FriendlyByteBuf p_44294_) {
            String s = p_44294_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_44294_.readEnum(CraftingBookCategory.class);
            int i = p_44294_.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.fromNetwork((FriendlyByteBuf)p_44294_));
            }
            ItemStack itemstack = p_44294_.readItem();
            return new RecipeCraftingShapelessCustomOutput(this, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf p_44281_, RecipeCraftingShapelessCustomOutput p_44282_) {
            p_44281_.writeUtf(p_44282_.getGroup());
            p_44281_.writeEnum((Enum)p_44282_.category());
            p_44281_.writeVarInt(p_44282_.getIngredients().size());
            for (Ingredient ingredient : p_44282_.getIngredients()) {
                ingredient.toNetwork(p_44281_);
            }
            p_44281_.writeItem(p_44282_.getRecipeOutput());
        }

        public static interface IOutputTransformer {
            public ItemStack transform(CraftingContainer var1, ItemStack var2);
        }
    }
}

