/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import net.swedz.tesseract.neoforge.TesseractMod;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookEfficiency;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookListener;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookRegistry;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHooks;
import net.swedz.tesseract.neoforge.compat.mi.hook.TesseractMIHookEntrypoint;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class MIMixinPlugin
implements IMixinConfigPlugin {
    private <H> boolean registerEntrypoint(ModFileScanData data, Class<?> entrypointClass, Class<H> hookClass, BiConsumer<String, H> register) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (hookClass.isAssignableFrom(entrypointClass)) {
            Class<H> hookClassReference = entrypointClass.asSubclass(hookClass);
            H hook = hookClassReference.getConstructor(new Class[0]).newInstance(new Object[0]);
            String id = ((IModInfo)((IModFileInfo)data.getIModInfoData().get(0)).getMods().get(0)).getModId();
            register.accept(id, hook);
            return true;
        }
        return false;
    }

    private List<ModFileScanData> getAllScanData() {
        return LoadingModList.get().getMods().stream().map(IModInfo::getOwningFile).filter(Objects::nonNull).map(IModFileInfo::getFile).distinct().map(IModFile::getScanResult).toList();
    }

    public void onLoad(String mixinPackage) {
        Type entrypointType = Type.getType(TesseractMIHookEntrypoint.class);
        for (ModFileScanData data : this.getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                try {
                    if (!entrypointType.equals((Object)annotation.annotationType())) continue;
                    Class<?> entrypointClass = Class.forName(annotation.memberName());
                    boolean registered = false;
                    if (this.registerEntrypoint(data, entrypointClass, MIHookListener.class, MIHooks::registerListener)) {
                        registered = true;
                    } else if (this.registerEntrypoint(data, entrypointClass, MIHookRegistry.class, MIHooks::registerRegistry)) {
                        registered = true;
                    } else if (this.registerEntrypoint(data, entrypointClass, MIHookEfficiency.class, MIHooks::registerEfficiencyListener)) {
                        registered = true;
                    }
                    if (registered) continue;
                    TesseractMod.LOGGER.error("TesseractMIHookEntrypoint {} does not implement a valid hook entrypoint", (Object)annotation.memberName());
                }
                catch (Throwable ex) {
                    TesseractMod.LOGGER.error("Exception constructing entrypoint:", ex);
                }
            }
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return TesseractMod.isMILoaded();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

