/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component.craft;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.stats.PlayerStatistics;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import aztech.modern_industrialization.util.Simulation;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookEfficiency;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHooks;
import net.swedz.tesseract.neoforge.compat.mi.hook.context.machine.EfficiencyMIHookContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ModularCrafterAccessBehavior {
    default public boolean isEnabled() {
        return true;
    }

    public long consumeEu(long var1, Simulation var3);

    default public boolean canConsumeEu(long amount) {
        return this.consumeEu(amount, Simulation.SIMULATE) == amount;
    }

    default public boolean isRecipeBanned(long recipeEuCost) {
        return recipeEuCost > this.getMaxRecipeEu();
    }

    public long getBaseRecipeEu();

    public long getBaseMaxRecipeEu();

    @ApiStatus.NonExtendable
    default public long getMaxRecipeEu() {
        MachineBlockEntity machineBlockEntity;
        long maxRecipeEu = this.getBaseMaxRecipeEu();
        ModularCrafterAccessBehavior modularCrafterAccessBehavior = this;
        if (modularCrafterAccessBehavior instanceof MachineBlockEntity && (machineBlockEntity = (MachineBlockEntity)modularCrafterAccessBehavior) instanceof CrafterComponentHolder) {
            CrafterComponentHolder crafterComponentHolder = (CrafterComponentHolder)machineBlockEntity;
            CrafterAccess crafter = crafterComponentHolder.getCrafterComponent();
            EfficiencyMIHookContext context = new EfficiencyMIHookContext(machineBlockEntity, crafter.hasActiveRecipe(), crafter.getMaxEfficiencyTicks(), crafter.getEfficiencyTicks(), maxRecipeEu);
            MIHooks.triggerHookEfficiencyListeners(context, MIHookEfficiency::onGetRecipeMaxEu);
            return context.getMaxRecipeEu();
        }
        return maxRecipeEu;
    }

    public Level getCrafterWorld();

    default public int getMaxFluidOutputs() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public UUID getOwnerUuid();

    default public PlayerStatistics getStatsOrDummy() {
        UUID uuid = this.getOwnerUuid();
        if (uuid == null) {
            return PlayerStatistics.DUMMY;
        }
        return PlayerStatisticsData.get((MinecraftServer)this.getCrafterWorld().getServer()).get(uuid);
    }
}

