/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied;

import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.AbstractModularCrafterComponent;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;

public final class MultipliedCrafterComponent
extends AbstractModularCrafterComponent<RecipeHolder<MachineRecipe>> {
    private final Supplier<MachineRecipeType> recipeTypeGetter;
    private final Supplier<Integer> maxMultiplierGetter;
    private final Supplier<EuCostTransformer> euCostTransformer;
    private int tryRecipeMultiplier = 0;
    private int recipeMultiplier = 0;

    public MultipliedCrafterComponent(MachineBlockEntity blockEntity, CrafterComponent.Inventory inventory, ModularCrafterAccessBehavior behavior, Supplier<MachineRecipeType> recipeTypeGetter, Supplier<Integer> maxMultiplierGetter, Supplier<EuCostTransformer> euCostTransformer) {
        super(blockEntity, inventory, behavior);
        this.recipeTypeGetter = recipeTypeGetter;
        this.maxMultiplierGetter = maxMultiplierGetter;
        this.euCostTransformer = euCostTransformer;
    }

    public MachineRecipeType getRecipeType() {
        return this.recipeTypeGetter.get();
    }

    public int getRecipeMultiplier() {
        return this.recipeMultiplier;
    }

    public int getMaxMultiplier() {
        return this.maxMultiplierGetter.get();
    }

    @Override
    public long transformEuCost(long eu) {
        return this.euCostTransformer.get().transform(this, eu);
    }

    @Override
    protected boolean canContinueRecipe() {
        return this.recipeMultiplier != 0;
    }

    @Override
    protected ResourceLocation getRecipeId(RecipeHolder<MachineRecipe> recipe) {
        return recipe.id();
    }

    @Override
    protected RecipeHolder<MachineRecipe> getRecipeById(ResourceLocation recipeId) {
        return this.getRecipeType().getRecipe(this.behavior.getCrafterWorld(), recipeId);
    }

    public long getBaseRecipeEu() {
        return ((MachineRecipe)((RecipeHolder)this.activeRecipe).value()).eu;
    }

    @Override
    public long getRecipeEuCost(RecipeHolder<MachineRecipe> recipe) {
        return ((MachineRecipe)recipe.value()).eu;
    }

    @Override
    public long getRecipeTotalEuCost(RecipeHolder<MachineRecipe> recipe) {
        return ((MachineRecipe)recipe.value()).getTotalEu();
    }

    @Override
    public boolean doConditionsMatchForRecipe(RecipeHolder<MachineRecipe> recipe) {
        return ((MachineRecipe)recipe.value()).conditionsMatch(this.conditionContext);
    }

    @Override
    protected void onTick() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Iterable<RecipeHolder<MachineRecipe>> getRecipes() {
        if (this.getRecipeType() == null) {
            return Collections.emptyList();
        }
        if (this.efficiencyTicks > 0) {
            return Collections.singletonList((RecipeHolder)this.activeRecipe);
        }
        int currentHash = this.inventory.hash();
        if (currentHash == this.lastInvHash) {
            if (this.lastForcedTick != 0) {
                --this.lastForcedTick;
                return Collections.emptyList();
            }
            this.lastForcedTick = 100;
        } else {
            this.lastInvHash = currentHash;
        }
        ServerLevel serverWorld = (ServerLevel)this.behavior.getCrafterWorld();
        MachineRecipeType recipeType = this.getRecipeType();
        ArrayList<RecipeHolder<MachineRecipe>> recipes = new ArrayList<RecipeHolder<MachineRecipe>>(recipeType.getFluidOnlyRecipes(serverWorld));
        Iterator iterator = this.inventory.getItemInputs().iterator();
        while (iterator.hasNext()) {
            ConfigurableItemStack stack = (ConfigurableItemStack)iterator.next();
            if (stack.isEmpty()) continue;
            recipes.addAll(recipeType.getMatchingRecipes(serverWorld, ((ItemVariant)stack.getResource()).getItem()));
        }
        return recipes;
    }

    private int calculateItemInputRecipeMultiplier(MachineRecipe recipe) {
        List<ItemStack> itemsInHatches = this.inventory.getItemInputs().stream().map(item -> ((ItemVariant)item.getResource()).toStack((int)item.getAmount())).toList();
        int itemMultiplier = this.getMaxMultiplier();
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            int countItemsInHatches = 0;
            for (ItemStack stack : itemsInHatches) {
                if (!input.matches(stack)) continue;
                countItemsInHatches += stack.getCount();
            }
            int multiplier = countItemsInHatches / input.amount;
            if (multiplier < itemMultiplier) {
                itemMultiplier = multiplier;
            }
            if (itemMultiplier > 1) continue;
            break;
        }
        return itemMultiplier;
    }

    private int calculateItemOutputRecipeMultiplier(MachineRecipe recipe) {
        List<ItemStack> itemsInHatches = this.inventory.getItemOutputs().stream().map(item -> ((ItemVariant)item.getResource()).toStack((int)item.getAmount())).toList();
        int itemMultiplier = this.getMaxMultiplier();
        for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
            int multiplier;
            if (output.probability < 1.0f) continue;
            int maxOutputCount = output.amount * this.getMaxMultiplier();
            int outputSpace = 0;
            for (ConfigurableItemStack item2 : this.inventory.getItemOutputs()) {
                int remainingCapacity;
                ItemVariant key = (ItemVariant)item2.getResource();
                if (key.getItem() != output.item && !key.isBlank() || (outputSpace += (remainingCapacity = (int)item2.getRemainingCapacityFor(ItemVariant.of((ItemLike)output.item)))) < maxOutputCount) continue;
                outputSpace = maxOutputCount;
                break;
            }
            if ((multiplier = outputSpace / output.amount) < itemMultiplier) {
                itemMultiplier = multiplier;
            }
            if (itemMultiplier > 1) continue;
            break;
        }
        return itemMultiplier;
    }

    private int calculateFluidInputRecipeMultiplier(MachineRecipe recipe) {
        int fluidMultiplier = this.getMaxMultiplier();
        for (MachineRecipe.FluidInput input : recipe.fluidInputs) {
            long countFluidInHatches = 0L;
            for (ConfigurableFluidStack stack : this.inventory.getFluidInputs()) {
                if (!((FluidVariant)stack.getResource()).equals(FluidVariant.of((Fluid)input.fluid))) continue;
                countFluidInHatches += stack.getAmount();
            }
            int multiplier = (int)(countFluidInHatches / input.amount);
            if (multiplier < fluidMultiplier) {
                fluidMultiplier = multiplier;
            }
            if (fluidMultiplier > 1) continue;
            break;
        }
        return fluidMultiplier;
    }

    private int calculateFluidOutputRecipeMultiplier(MachineRecipe recipe) {
        int fluidMultiplier = this.getMaxMultiplier();
        block0: for (int i = 0; i < Math.min(recipe.fluidOutputs.size(), this.behavior.getMaxFluidOutputs()); ++i) {
            MachineRecipe.FluidOutput output = (MachineRecipe.FluidOutput)recipe.fluidOutputs.get(i);
            if (output.probability < 1.0f) continue;
            long maxOutputCount = output.amount * (long)this.getMaxMultiplier();
            for (int tries = 0; tries < 2; ++tries) {
                for (ConfigurableFluidStack stack : this.inventory.getFluidOutputs()) {
                    FluidVariant outputKey;
                    if (!stack.isResourceAllowedByLock((TransferVariant)(outputKey = FluidVariant.of((Fluid)output.fluid))) || (tries != 1 || !stack.isResourceBlank()) && !((FluidVariant)stack.getResource()).equals(outputKey)) continue;
                    long outputSpace = Math.min(stack.getRemainingSpace(), maxOutputCount);
                    int multiplier = (int)(outputSpace / output.amount);
                    if (multiplier < fluidMultiplier) {
                        fluidMultiplier = multiplier;
                    }
                    if (fluidMultiplier > 1) continue;
                    continue block0;
                }
            }
        }
        return fluidMultiplier;
    }

    @Override
    protected boolean takeItemInputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate) {
        MachineRecipe recipe = (MachineRecipe)recipeHolder.value();
        List baseList = this.inventory.getItemInputs();
        List stacks = simulate ? ConfigurableItemStack.copyList((List)baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            if (!simulate && input.probability < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability) continue;
            int remainingAmount = input.amount * this.tryRecipeMultiplier;
            for (ConfigurableItemStack stack : stacks) {
                if (stack.getAmount() <= 0L || !input.matches(((ItemVariant)stack.getResource()).toStack())) continue;
                int taken = Math.min((int)stack.getAmount(), remainingAmount);
                if (taken > 0 && !simulate) {
                    this.behavior.getStatsOrDummy().addUsedItems((ItemLike)((ItemVariant)stack.getResource()).getItem(), (long)taken);
                }
                stack.decrement((long)taken);
                if ((remainingAmount -= taken) != 0) continue;
                break;
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        return ok;
    }

    @Override
    protected boolean takeFluidInputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate) {
        MachineRecipe recipe = (MachineRecipe)recipeHolder.value();
        List baseList = this.inventory.getFluidInputs();
        List stacks = simulate ? ConfigurableFluidStack.copyList((List)baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.FluidInput input : recipe.fluidInputs) {
            if (!simulate && input.probability < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability) continue;
            long remainingAmount = input.amount * (long)this.tryRecipeMultiplier;
            for (ConfigurableFluidStack stack : stacks) {
                if (!((FluidVariant)stack.getResource()).equals(FluidVariant.of((Fluid)input.fluid))) continue;
                long taken = Math.min(remainingAmount, stack.getAmount());
                if (taken > 0L && !simulate) {
                    this.behavior.getStatsOrDummy().addUsedFluids(((FluidVariant)stack.getResource()).getFluid(), taken);
                }
                stack.decrement(taken);
                if ((remainingAmount -= taken) != 0L) continue;
                break;
            }
            if (remainingAmount <= 0L) continue;
            ok = false;
        }
        return ok;
    }

    @Override
    protected boolean putItemOutputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate, boolean toggleLock) {
        MachineRecipe recipe = (MachineRecipe)recipeHolder.value();
        int recipeMultiplier = this.tryRecipeMultiplier == 0 ? this.recipeMultiplier : this.tryRecipeMultiplier;
        List baseList = this.inventory.getItemOutputs();
        List stacks = simulate ? ConfigurableItemStack.copyList((List)baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<Item> lockItems = new ArrayList<Item>();
        boolean ok = true;
        for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
            float randFloat;
            if (output.probability < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability)) continue;
            int remainingAmount = output.amount * recipeMultiplier;
            block1: for (int loopRun = 0; loopRun < 2; ++loopRun) {
                int stackId = 0;
                for (ConfigurableItemStack stack : stacks) {
                    ++stackId;
                    ItemVariant key = (ItemVariant)stack.getResource();
                    if (key.getItem() != output.item && !key.isBlank()) continue;
                    int remainingCapacity = simulate || output.probability < 1.0f ? (int)stack.getRemainingCapacityFor(ItemVariant.of((ItemLike)output.item)) : output.item.getMaxStackSize() - (int)stack.getAmount();
                    int ins = Math.min(remainingAmount, remainingCapacity);
                    if (key.isBlank()) {
                        if ((stack.isMachineLocked() || stack.isPlayerLocked() || loopRun == 1) && stack.isValid(new ItemStack((ItemLike)output.item))) {
                            stack.setAmount((long)ins);
                            stack.setKey((TransferVariant)ItemVariant.of((ItemLike)output.item));
                        } else {
                            ins = 0;
                        }
                    } else {
                        stack.increment((long)ins);
                    }
                    remainingAmount -= ins;
                    if (ins > 0) {
                        locksToToggle.add(stackId - 1);
                        lockItems.add(output.item);
                        if (!simulate) {
                            this.behavior.getStatsOrDummy().addProducedItems(this.behavior.getCrafterWorld(), (ItemLike)output.item, (long)ins);
                        }
                    }
                    if (remainingAmount != 0) continue;
                    continue block1;
                }
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        if (toggleLock) {
            for (int i = 0; i < locksToToggle.size(); ++i) {
                ((ConfigurableItemStack)baseList.get((Integer)locksToToggle.get(i))).enableMachineLock((Object)((Item)lockItems.get(i)));
            }
        }
        return ok;
    }

    @Override
    protected boolean putFluidOutputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate, boolean toggleLock) {
        int i;
        MachineRecipe recipe = (MachineRecipe)recipeHolder.value();
        int recipeMultiplier = this.tryRecipeMultiplier == 0 ? this.recipeMultiplier : this.tryRecipeMultiplier;
        List baseList = this.inventory.getFluidOutputs();
        List stacks = simulate ? ConfigurableFluidStack.copyList((List)baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<Fluid> lockFluids = new ArrayList<Fluid>();
        boolean ok = true;
        block0: for (i = 0; i < Math.min(recipe.fluidOutputs.size(), this.behavior.getMaxFluidOutputs()); ++i) {
            float randFloat;
            MachineRecipe.FluidOutput output = (MachineRecipe.FluidOutput)recipe.fluidOutputs.get(i);
            if (output.probability < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability)) continue;
            for (int tries = 0; tries < 2; ++tries) {
                for (int j = 0; j < stacks.size(); ++j) {
                    FluidVariant outputKey;
                    ConfigurableFluidStack stack = (ConfigurableFluidStack)stacks.get(j);
                    if (!stack.isResourceAllowedByLock((TransferVariant)(outputKey = FluidVariant.of((Fluid)output.fluid))) || (tries != 1 || !stack.isResourceBlank()) && !((FluidVariant)stack.getResource()).equals(outputKey)) continue;
                    long inserted = Math.min(output.amount * (long)recipeMultiplier, stack.getRemainingSpace());
                    if (inserted > 0L) {
                        stack.setKey((TransferVariant)outputKey);
                        stack.increment(inserted);
                        locksToToggle.add(j);
                        lockFluids.add(output.fluid);
                        if (!simulate) {
                            this.behavior.getStatsOrDummy().addProducedFluids(output.fluid, inserted);
                        }
                    }
                    if (inserted >= output.amount * (long)recipeMultiplier) continue block0;
                    ok = false;
                    continue block0;
                }
                if (tries != 1) continue;
                ok = false;
            }
        }
        if (toggleLock) {
            for (i = 0; i < locksToToggle.size(); ++i) {
                ((ConfigurableFluidStack)baseList.get((Integer)locksToToggle.get(i))).enableMachineLock((Object)((Fluid)lockFluids.get(i)));
            }
        }
        return ok;
    }

    @Override
    protected boolean tryStartRecipe(RecipeHolder<MachineRecipe> recipe) {
        int itemOutputMultiplier;
        int itemInputMultiplier;
        if (this.getMaxMultiplier() > 1 && (itemInputMultiplier = this.calculateItemInputRecipeMultiplier((MachineRecipe)recipe.value())) > 1 && (itemOutputMultiplier = this.calculateItemOutputRecipeMultiplier((MachineRecipe)recipe.value())) > 1) {
            int fluidOutputMultiplier;
            int itemMultiplier = Math.min(itemInputMultiplier, itemOutputMultiplier);
            int fluidInputMultiplier = this.calculateFluidInputRecipeMultiplier((MachineRecipe)recipe.value());
            if (fluidInputMultiplier > 1 && (fluidOutputMultiplier = this.calculateFluidOutputRecipeMultiplier((MachineRecipe)recipe.value())) > 1) {
                int fluidMultiplier = Math.min(fluidInputMultiplier, fluidOutputMultiplier);
                this.tryRecipeMultiplier = Math.min(itemMultiplier, fluidMultiplier);
                if (super.tryStartRecipe(recipe)) {
                    this.recipeMultiplier = this.tryRecipeMultiplier;
                    this.tryRecipeMultiplier = 0;
                    return true;
                }
            }
        }
        this.tryRecipeMultiplier = 1;
        this.recipeMultiplier = 1;
        boolean success = super.tryStartRecipe(recipe);
        this.tryRecipeMultiplier = 0;
        return success;
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        super.writeNbt(tag);
        tag.putInt("recipeMultiplier", this.recipeMultiplier);
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        super.readNbt(tag, isUpgradingMachine);
        this.recipeMultiplier = tag.getInt("recipeMultiplier");
    }

    @Override
    protected void clearActiveRecipes() {
        super.clearActiveRecipes();
        this.recipeMultiplier = 0;
    }

    @Override
    public void lockRecipe(ResourceLocation recipeId, Inventory inventory) {
        MachineRecipeType recipeType = this.getRecipeType();
        if (recipeType == null) {
            return;
        }
        Optional<RecipeHolder> optionalMachineRecipe = recipeType.getRecipes(this.behavior.getCrafterWorld()).stream().filter(recipe -> recipe.id().equals((Object)recipeId)).findFirst();
        if (optionalMachineRecipe.isEmpty()) {
            return;
        }
        RecipeHolder recipe2 = optionalMachineRecipe.get();
        block0: for (MachineRecipe.ItemInput input : ((MachineRecipe)recipe2.value()).itemInputs) {
            for (ConfigurableItemStack stack : this.inventory.getItemInputs()) {
                if (stack.getLockedInstance() == null || !input.matches(new ItemStack((ItemLike)stack.getLockedInstance()))) continue;
                continue block0;
            }
            Item targetItem = null;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack playerStack = inventory.getItem(i);
                if (playerStack.isEmpty() || !input.matches(new ItemStack((ItemLike)playerStack.getItem()))) continue;
                targetItem = playerStack.getItem();
                break;
            }
            if (targetItem == null) {
                for (Item item : input.getInputItems()) {
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
                    if (!id.getNamespace().equals("modern_industrialization")) continue;
                    targetItem = item;
                    break;
                }
            }
            if (targetItem == null && input.getInputItems().size() == 1) {
                targetItem = (Item)input.getInputItems().get(0);
            }
            if (targetItem == null) continue;
            AbstractConfigurableStack.playerLockNoOverride(targetItem, (List)this.inventory.getItemInputs());
        }
        block4: for (MachineRecipe.ItemOutput output : ((MachineRecipe)recipe2.value()).itemOutputs) {
            for (ConfigurableItemStack stack : this.inventory.getItemOutputs()) {
                if (stack.getLockedInstance() != output.item) continue;
                continue block4;
            }
            AbstractConfigurableStack.playerLockNoOverride((Object)output.item, (List)this.inventory.getItemOutputs());
        }
        block6: for (MachineRecipe.ItemInput input : ((MachineRecipe)recipe2.value()).fluidInputs) {
            for (ConfigurableItemStack stack : this.inventory.getFluidInputs()) {
                if (!stack.isLockedTo((Object)input.fluid)) continue;
                continue block6;
            }
            AbstractConfigurableStack.playerLockNoOverride((Object)input.fluid, (List)this.inventory.getFluidInputs());
        }
        block8: for (MachineRecipe.ItemOutput output : ((MachineRecipe)recipe2.value()).fluidOutputs) {
            for (ConfigurableItemStack stack : this.inventory.getFluidOutputs()) {
                if (!stack.isLockedTo((Object)output.fluid)) continue;
                continue block8;
            }
            AbstractConfigurableStack.playerLockNoOverride((Object)output.fluid, (List)this.inventory.getFluidOutputs());
        }
        if (!((MachineRecipe)recipe2.value()).itemInputs.isEmpty() || !((MachineRecipe)recipe2.value()).itemOutputs.isEmpty()) {
            MultipliedCrafterComponent.lockAll(this.inventory.getItemInputs());
            MultipliedCrafterComponent.lockAll(this.inventory.getItemOutputs());
        }
        if (!((MachineRecipe)recipe2.value()).fluidInputs.isEmpty() || !((MachineRecipe)recipe2.value()).fluidOutputs.isEmpty()) {
            MultipliedCrafterComponent.lockAll(this.inventory.getFluidInputs());
            MultipliedCrafterComponent.lockAll(this.inventory.getFluidOutputs());
        }
    }
}

