/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel;

import aztech.modern_industrialization.machines.gui.GuiComponent;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.TesseractMod;

public final class ConfigurationPanel {
    public static final ResourceLocation ID = TesseractMod.id("configuration_panel");

    public static class Server
    implements GuiComponent.Server<int[]> {
        public final Behavior behavior;
        private final Component title;
        private final Component description;
        private final List<LineInfo> lines;

        public Server(Behavior behavior, Component title, Component description, LineInfo ... lines) {
            Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0);
            this.behavior = behavior;
            this.title = title;
            this.description = description;
            this.lines = List.of(lines);
        }

        public int[] copyData() {
            return IntStream.range(0, this.lines.size()).map(this.behavior::getCurrentIndex).toArray();
        }

        public boolean needsSync(int[] cachedData) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (cachedData[i] == this.behavior.getCurrentIndex(i)) continue;
                return true;
            }
            return false;
        }

        public void writeInitialData(FriendlyByteBuf buf) {
            buf.writeComponent(this.title);
            buf.writeComponent(this.description);
            buf.writeVarInt(this.lines.size());
            for (LineInfo line : this.lines) {
                buf.writeVarInt(line.numValues);
                for (Component component : line.translations) {
                    buf.writeComponent(component);
                }
                buf.writeBoolean(line.useArrows);
            }
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(FriendlyByteBuf buf) {
            for (int i = 0; i < this.lines.size(); ++i) {
                buf.writeVarInt(this.behavior.getCurrentIndex(i));
            }
        }

        public ResourceLocation getId() {
            return ID;
        }
    }

    public record LineInfo(int numValues, List<? extends Component> translations, boolean useArrows) {
        public LineInfo {
            Preconditions.checkArgument((numValues == translations.size() ? 1 : 0) != 0);
        }
    }

    public static interface Behavior {
        public void handleClick(int var1, int var2);

        public int getCurrentIndex(int var1);
    }
}

