/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel;

import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.Rectangle;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanel;
import net.swedz.tesseract.neoforge.compat.mi.network.packets.UpdateMachineConfigurationPanelPacket;

public final class ConfigurationPanelClient
implements GuiComponentClient {
    private final Component title;
    private final Component description;
    private final ConfigurationPanel.LineInfo[] lines;
    final int[] currentData;
    private Renderer renderer;

    public ConfigurationPanelClient(FriendlyByteBuf buf) {
        this.title = buf.readComponent();
        this.description = buf.readComponent();
        this.lines = new ConfigurationPanel.LineInfo[buf.readVarInt()];
        for (int i = 0; i < this.lines.length; ++i) {
            int numValues = buf.readVarInt();
            ArrayList<Component> components = new ArrayList<Component>();
            for (int j = 0; j < numValues; ++j) {
                components.add(buf.readComponent());
            }
            this.lines[i] = new ConfigurationPanel.LineInfo(numValues, components, buf.readBoolean());
        }
        this.currentData = new int[this.lines.length];
        this.readCurrentData(buf);
    }

    public void readCurrentData(FriendlyByteBuf buf) {
        for (int i = 0; i < this.currentData.length; ++i) {
            this.currentData[i] = buf.readVarInt();
        }
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        int maxWidth = 1;
        for (ConfigurationPanel.LineInfo line : this.lines) {
            for (Component component : line.translations()) {
                maxWidth = Math.max(maxWidth, Minecraft.getInstance().font.width((FormattedText)component));
            }
        }
        this.renderer = new Renderer(maxWidth);
        return this.renderer;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    class Renderer
    implements ClientComponentRenderer {
        boolean isPanelOpen = false;
        private final int btnSize = 12;
        private final int borderSize = 3;
        private final int outerPadding = 5;
        private final int innerPadding = 5;
        private final int textMaxWidth;
        private final int panelWidth;

        private Renderer(int textMaxWidth) {
            this.textMaxWidth = textMaxWidth;
            this.panelWidth = 25 + textMaxWidth + 5 + 12 + 5;
        }

        private static int getVerticalPos(int lineId) {
            return 46 + 16 * lineId;
        }

        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            for (int i = 0; i < ConfigurationPanelClient.this.lines.length; ++i) {
                int iCopy = i;
                ConfigurationPanel.LineInfo line = ConfigurationPanelClient.this.lines[i];
                int baseU = line.useArrows() ? 174 : 150;
                int v = 58;
                container.addButton(-this.panelWidth + 3 + 5, Renderer.getVerticalPos(i), 12, 12, syncId -> new UpdateMachineConfigurationPanelPacket((int)syncId, iCopy, true).sendToServer(), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if (ConfigurationPanelClient.this.currentData[iCopy] == 0) {
                        screen.blitButtonNoHighlight((Button)button, guiGraphics, baseU, v + 12);
                    } else {
                        screen.blitButtonSmall((Button)button, guiGraphics, baseU, v);
                    }
                }, () -> this.isPanelOpen);
                container.addButton(-17, Renderer.getVerticalPos(i), 12, 12, syncId -> new UpdateMachineConfigurationPanelPacket((int)syncId, iCopy, false).sendToServer(), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if (ConfigurationPanelClient.this.currentData[iCopy] == line.numValues() - 1) {
                        screen.blitButtonNoHighlight((Button)button, guiGraphics, baseU + 12, v + 12);
                    } else {
                        screen.blitButtonSmall((Button)button, guiGraphics, baseU + 12, v);
                    }
                }, () -> this.isPanelOpen);
            }
            container.addButton(-24, 17, 20, 20, syncId -> {
                this.isPanelOpen = !this.isPanelOpen;
            }, () -> List.of(ConfigurationPanelClient.this.title, ConfigurationPanelClient.this.description), (screen, button, guiGraphics, mouseX, mouseY, delta) -> screen.blitButton((Button)button, guiGraphics, 138, 38));
        }

        public void renderBackground(GuiGraphics guiGraphics, int leftPos, int topPos) {
            Rectangle box = this.getBox(leftPos, topPos);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), 0, 0, box.w(), box.h() - 4);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, 0, 252, box.w(), 4);
            if (this.isPanelOpen) {
                RenderSystem.disableDepthTest();
                for (int i = 0; i < ConfigurationPanelClient.this.lines.length; ++i) {
                    ConfigurationPanel.LineInfo line = ConfigurationPanelClient.this.lines[i];
                    Component tooltip = line.translations().get(ConfigurationPanelClient.this.currentData[i]);
                    int width = Minecraft.getInstance().font.width((FormattedText)tooltip);
                    guiGraphics.drawString(Minecraft.getInstance().font, tooltip, box.x() + 3 + 5 + 12 + 5 + (this.textMaxWidth - width) / 2, topPos + Renderer.getVerticalPos(i) + 2, 0x404040, false);
                }
                RenderSystem.enableDepthTest();
            }
        }

        public Rectangle getBox(int leftPos, int topPos) {
            if (this.isPanelOpen) {
                int topOffset = 10;
                return new Rectangle(leftPos - this.panelWidth, topPos + topOffset, this.panelWidth, Renderer.getVerticalPos(ConfigurationPanelClient.this.lines.length - 1) - topOffset + 12 + 5 + 3);
            }
            return new Rectangle(leftPos - 31, topPos + 10, 31, 34);
        }

        public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
            rectangles.add(this.getBox(leftPos, topPos));
        }
    }
}

