/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock;

import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.TesseractMod;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiLine;

public final class ModularMultiblockGui {
    public static final ResourceLocation ID = TesseractMod.id("modular_multiblock");
    public static final int X = 4;
    public static final int Y = 16;
    public static final int W = 166;
    public static final int H = 80;

    private record Data(int height, List<ModularMultiblockGuiLine> text) {
    }

    public static final class Server
    implements GuiComponent.Server<Data> {
        private final int height;
        private final Supplier<List<ModularMultiblockGuiLine>> textSupplier;

        public Server(int height, Supplier<List<ModularMultiblockGuiLine>> textSupplier) {
            if (height <= 4 || height > 80) {
                throw new IllegalArgumentException("Provided height outside of acceptable bounds");
            }
            this.height = height;
            this.textSupplier = textSupplier;
        }

        public Data copyData() {
            return new Data(this.height, this.textSupplier.get());
        }

        public boolean needsSync(Data cachedData) {
            return !cachedData.equals(this.copyData());
        }

        public void writeInitialData(FriendlyByteBuf buf) {
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(FriendlyByteBuf buf) {
            buf.writeInt(this.height);
            buf.writeCollection((Collection)this.textSupplier.get(), ModularMultiblockGuiLine::write);
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

